/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.scheduler;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.PeriodicTaskExceptionHandler;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class SchedulerTest {
    private static final Scheduler scheduler = new Scheduler("Scheduler test", 3);

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
        scheduler.shutdownNow();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLogging() {
        Scheduler s = new Scheduler("Logging test", 2);
        s.setMaxFailures(3);
        StringBuffer sb = new StringBuffer();
        s.schedule(() -> {
            sb.append("1");
            throw new RuntimeException("1");
        }, 0L, TimeUnit.SECONDS);
        s.schedule(() -> {
            sb.append("2");
            throw new RuntimeException("2");
        }, 0L, TimeUnit.SECONDS);
        s.scheduleWithFixedDelay(() -> {
            sb.append("3");
            throw new RuntimeException("3");
        }, 0L, 10L, TimeUnit.MILLISECONDS, "task 3", Level.ALL);
        s.schedule(() -> s.shutdown(), 1L, TimeUnit.SECONDS);
        try {
            s.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        char[] ca = sb.toString().toCharArray();
        Arrays.sort(ca);
        StringBuilder out = new StringBuilder(sb.length());
        for (char c : ca) {
            out.append(c);
        }
        Assert.assertEquals((Object)"12333", (Object)out.toString());
    }

    @Test
    public void testSkipping() {
        Scheduler s = new Scheduler("E", 1);
        final StringBuffer sb = new StringBuffer();
        AtomicInteger count = new AtomicInteger(0);
        final AtomicInteger longTasks = new AtomicInteger(0);
        AtomicLong time = new AtomicLong(System.currentTimeMillis());
        PeriodicTaskExceptionHandler exceptionHandler = new PeriodicTaskExceptionHandler(){

            public void onSkippedExecutions(PeriodicTask task, int nSkipped) {
                sb.append("S").append(nSkipped).append(Thread.currentThread().getName());
            }

            public void onLongExecution(PeriodicTask task) {
                longTasks.incrementAndGet();
            }
        };
        exceptionHandler.setSkipOverdueExecutions(true);
        exceptionHandler.setDetectLongExecutions(true);
        exceptionHandler.setMaxFailures(2);
        s.scheduleAtFixedRate(() -> {
            int i = count.getAndIncrement();
            long now = System.currentTimeMillis();
            long t = Math.round((double)(now - time.getAndSet(now)) / 1000.0);
            sb.append(i).append(t);
            if (i == 2) {
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {}
            } else if (i == 4) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {}
            } else if (i > 5) {
                throw new RuntimeException();
            }
        }, 0L, 1L, TimeUnit.SECONDS, "T", exceptionHandler);
        s.schedule(() -> s.shutdown(), 10500L, TimeUnit.MILLISECONDS);
        try {
            s.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"001121S2E3341S1E526171", (Object)sb.toString());
        Assert.assertEquals((String)"Long task count", (long)2L, (long)longTasks.get());
    }

    @Test
    public void testExceptions() {
        Scheduler s = new Scheduler("name", 1);
        final StringBuffer sb = new StringBuffer();
        AtomicInteger count = new AtomicInteger(0);
        PeriodicTaskExceptionHandler exceptionHandler = new PeriodicTaskExceptionHandler(){

            public void onException(PeriodicTask task, Throwable exception) {
                sb.append("E");
            }

            public void onFinalException(PeriodicTask task, Throwable exception) {
                sb.append("F");
            }
        };
        exceptionHandler.setResetFailureCountOnSuccess(false);
        exceptionHandler.setMaxFailures(2);
        s.scheduleAtFixedRate(() -> {
            int i = count.getAndIncrement();
            long now = System.currentTimeMillis();
            sb.append(i);
            switch (i) {
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    throw new RuntimeException();
                }
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS, "T", exceptionHandler);
        s.schedule(() -> s.shutdown(), 2L, TimeUnit.SECONDS);
        try {
            s.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"01E234F", (Object)sb.toString());
    }
}

