/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.pattern;

import java.util.HashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.pattern.FileNamePatternUtils;

public class FileNamePatternUtilsTest {
    @Test
    public void testPattern() {
        Properties p = new Properties();
        p.setProperty("test", "aaa");
        p.setProperty("s_1", "1");
        String fileName = "some_${test}_${p0}${s_1}";
        String resolvedPattern = FileNamePatternUtils.resolveFileName((String)fileName, (Properties)p);
        Assert.assertEquals((Object)"some_aaa_${p0}1", (Object)resolvedPattern);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("p0", "34");
        String resolvedPattern1 = FileNamePatternUtils.resolveFileName((String)fileName, map);
        Assert.assertEquals((Object)"some_${test}_34${s_1}", (Object)resolvedPattern1);
        resolvedPattern1 = FileNamePatternUtils.resolveFileName((String)resolvedPattern, map);
        Assert.assertEquals((Object)"some_aaa_341", (Object)resolvedPattern1);
        fileName = "${start}some_${test}_${p0}${s_1}";
        String resolvedPattern2 = FileNamePatternUtils.resolveFileName((String)fileName, (Properties)p);
        Assert.assertEquals((Object)"${start}some_aaa_${p0}1", (Object)resolvedPattern2);
        p.setProperty("start", "/");
        resolvedPattern2 = FileNamePatternUtils.resolveFileName((String)fileName, (Properties)p);
        Assert.assertEquals((Object)"/some_aaa_${p0}1", (Object)resolvedPattern2);
    }
}

