package org.lsst.ccs.utilities.structs;

import java.io.Serializable;
import java.util.Map;

/**
 * A simple tuple with two immutable values. can be used as a Map.Entry
 * @author bamade
 */
// Date: 17/11/12

public class UniquePair<K, V> implements Map.Entry<K, V>, Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = 6909509404037439711L;
	public final K key;
    public final V value;

    public UniquePair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public K getKey() {
        return key;
    }

    @Override
    public V getValue() {
        return value;
    }

    @Override
    public V setValue(V v) {
        throw new UnsupportedOperationException("no set on value");
    }

    @Override
    public String toString() {
        return "[" + key + "," + value + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof UniquePair)) return false;

        UniquePair that = (UniquePair) o;

        if (key != null ? !key.equals(that.key) : that.key != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return key != null ? key.hashCode() : 0;
    }
}
