/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.utilities.misc.Similarity;

public class SimilarityTest {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Test
    public void testCompute() {
        int result = Similarity.compute((String)"", (String)"");
        Assert.assertEquals((long)0L, (long)result);
        result = Similarity.compute((String)"fgh", (String)"fgh");
        Assert.assertEquals((long)0L, (long)result);
        result = Similarity.compute((String)"a", (String)"A");
        Assert.assertEquals((long)1L, (long)result);
        result = Similarity.compute((String)"abf", (String)"a1f");
        Assert.assertEquals((long)1L, (long)result);
        result = Similarity.compute((String)"abf", (String)"a1ff");
        Assert.assertEquals((long)2L, (long)result);
        result = Similarity.compute((String)"abf", (String)"ga1ff");
        Assert.assertEquals((long)3L, (long)result);
        result = Similarity.compute((String)"abf", (String)"rega1ff");
        Assert.assertEquals((long)5L, (long)result);
        Assert.assertEquals((long)Similarity.compute((String)"abfh sncyaq5284/tblpds", (String)"lsbxsubxiuw5284"), (long)Similarity.compute((String)"lsbxsubxiuw5284", (String)"abfh sncyaq5284/tblpds"));
    }

    @Test
    public void testHead_4args() {
        List<String> candidates = Arrays.asList(" ", "a1f", "dijncefi", "abf", "aaa", "                     ");
        List<String> expResult = Arrays.asList("abf", "a1f");
        ArrayList result = Similarity.head((String)"abf", candidates, (int)10, (int)2);
        Assert.assertEquals(expResult, (Object)result);
        expResult = Arrays.asList("abf", "a1f", "aaa");
        result = Similarity.head((String)"abf", candidates, (int)3, (int)100);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testComputeBiased() {
        int result = Similarity.computeBiased((String)"", (String)"");
        Assert.assertEquals((long)0L, (long)result);
        result = Similarity.computeBiased((String)"fgh", (String)"fgh");
        Assert.assertEquals((long)0L, (long)result);
        result = Similarity.computeBiased((String)"a", (String)"A");
        Assert.assertEquals((long)1L, (long)result);
        result = Similarity.computeBiased((String)"abf", (String)"a1f");
        Assert.assertEquals((long)1L, (long)result);
        result = Similarity.computeBiased((String)"abf", (String)"abfe");
        Assert.assertEquals((long)1L, (long)result);
        result = Similarity.computeBiased((String)"abf", (String)"abfegsdegwremigwerg");
        Assert.assertEquals((long)1L, (long)result);
        result = Similarity.computeBiased((String)"abfegsdegwremigwerg", (String)"abf");
        Assert.assertEquals((long)Similarity.compute((String)"abfegsdegwremigwerg", (String)"abf"), (long)result);
    }

    @Test
    public void testHead_5args() {
        List<String> candidates = Arrays.asList(" ", "a1f", "dijncefi", "abf", "aaa", "                     ", "abf1");
        List<String> expResult = Arrays.asList("abf", "a1f", "abf1");
        ArrayList result = Similarity.head((String)"abf", candidates, (int)3, (int)100);
        Assert.assertEquals(expResult, (Object)result);
    }
}

