package org.lsst.ccs.utilities.conv;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/**
 * Reverse operation of InputConversionEngine
 * @author The LSST CCS Team
 */
// Date: 04/09/13

public class TypeUtils {

    /**
     * String representation of a null object
     */
    public static final String NULL_STR="_null_";
    
    /**
     * Returns a String representation of the object passed as argument.
     * If the passed object is null, returns TypeUtils.NULL_STR.
     * @param obj
     * @return 
     */
    public static String stringify(Object obj){
        if (obj == null) return NULL_STR;
        String res ;
        if(obj instanceof BigDecimal) {
            res = ((BigDecimal)obj).toPlainString() ;
        } else if (obj instanceof Map) {
            // Dos not work properly : res= DefaultGroovyMethods.toMapString((Map) obj);
            res= toMapString((Map) obj);
        } else if (obj instanceof List) {
            // does not work properly : res= DefaultGroovyMethods.toListString((List) obj);
            res= toListString((List) obj);
        } else if(obj.getClass().isArray()) {
            res =  toArrayString(obj) ;
        } else if (obj instanceof Enum) {
            res = ((Enum)obj).name();
        } else {
            res = String.valueOf(obj) ;
        }
        return res ;

    }

    private static String  toArrayString(Object obj){
        StringBuilder builder = new StringBuilder("[");
        int size = Array.getLength(obj) ;
        for(int ix = 0 ; ix < size ; ix++) {
            Object item = Array.get(obj, ix);
            if(item instanceof String) {
//                builder.append("'").append(item).append("'") ;
                builder.append(item) ;
            } else {
                builder.append(stringify(item)) ;
            }

            if(ix < (size -1)) {
                builder.append(",");
            }
        }
        builder.append("]") ;
        return builder.toString();
    }
    //TODO : Double and Float string changed to "as double" "as Float" ?
    // rationale: this is of no importance for constuctors
    // but will probably need a distinct behaviour when we use "raw" lists
    private static String  toListString(List list){
        StringBuilder builder = new StringBuilder("[");
        int size = list.size();
        for(int ix = 0 ; ix < size ; ix++) {
            Object item = list.get(ix);
            if(item instanceof String) {
//                builder.append("'").append(item).append("'") ;
                builder.append(item) ;
            } else {
                builder.append(stringify(item)) ;
            }

            if(ix < (size -1)) {
                builder.append(",");
            }
        }
        builder.append("]") ;
        return builder.toString();
    }
    //TODO :change double and floats values as for List?
    // rationale: this is of no importance for constuctors
    // but will probably need a distinct behaviour when we use "raw" lists
    private static String  toMapString(Map map){
        StringBuilder builder = new StringBuilder("[");
        Set<Map.Entry> entries = new TreeSet<>(new Comparator<Map.Entry>() {

            @Override
            public int compare(Map.Entry o1, Map.Entry o2) {
                return String.valueOf(o1.getKey()).compareTo(String.valueOf(o2.getKey()));
            }
        });
        
        entries.addAll(map.entrySet()) ;
        int size =entries.size() ;
        int ix = 0 ;
        for(Map.Entry entry : entries) {
            builder.append(entry.getKey()).append(":") ;
            Object item = entry.getValue() ;
            if(item instanceof String) {
//                builder.append("'").append(item).append("'") ;
                builder.append(item) ;
            } else {
                builder.append(stringify(item)) ;
            }
            if(ix < (size -1)) {
                builder.append(",");
            }
            ix++ ;
        }
        builder.append("]") ;
        return builder.toString();
    }

}