/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.reflect;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.reflect.ClassMultipleCtors;
import org.lsst.ccs.utilities.reflect.ConstructorUtils;

public class ConstructorUtilsTest {
    @Test
    public void testFindConstructor() throws Exception {
        Constructor c1 = ConstructorUtils.getMatchingConstructor(ClassMultipleCtors.class, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Double.TYPE, Long.TYPE});
        Constructor c2 = ConstructorUtils.getMatchingConstructor(ClassMultipleCtors.class, (Class[])new Class[]{Integer.class, Integer.class, Double.class, Long.class});
        Constructor c3 = ConstructorUtils.getMatchingConstructor(ClassMultipleCtors.class, (Class[])new Class[]{Character.TYPE, Integer.class, Byte.TYPE, Integer.TYPE});
        Constructor c4 = ConstructorUtils.getMatchingConstructor(ClassMultipleCtors.class, (Class[])new Class[]{Byte.class, Integer.class, Character.class, Integer.class});
        Assert.assertNotNull((Object)c1);
        Assert.assertNotNull((Object)c2);
        Assert.assertNotNull((Object)c3);
        Assert.assertNotNull((Object)c4);
        Assert.assertEquals((Object)c1, (Object)c2);
        Assert.assertEquals((Object)c1, (Object)c3);
        Assert.assertEquals((Object)c1, (Object)c4);
        c1 = ConstructorUtils.getMatchingConstructor(ClassMultipleCtors.class, (Class[])new Class[]{String.class, Object.class, Object.class});
        Assert.assertNotNull((Object)c1);
        Assert.assertFalse((boolean)c1.isVarArgs());
        c1 = ConstructorUtils.getMatchingConstructor(ClassMultipleCtors.class, (Class[])new Class[]{String.class, Object.class, Object.class, String.class});
        Assert.assertNotNull((Object)c1);
        Assert.assertTrue((boolean)c1.isVarArgs());
        c1 = ConstructorUtils.getMatchingConstructor(ClassMultipleCtors.class, (Class[])new Class[]{String.class, ConstructorUtils.NULL_CLASS});
        Assert.assertNotNull((Object)c1);
        Assert.assertTrue((boolean)c1.isVarArgs());
        c1 = ConstructorUtils.getMatchingConstructor(ClassMultipleCtors.class, (Class[])new Class[]{ConstructorUtils.NULL_CLASS, ConstructorUtils.NULL_CLASS});
        Assert.assertNotNull((Object)c1);
        Assert.assertTrue((boolean)c1.isVarArgs());
        c1 = ConstructorUtils.getMatchingConstructor(ClassMultipleCtors.class, (Class[])new Class[]{String.class, Object.class, Integer.TYPE});
        Assert.assertNotNull((Object)c1);
        Assert.assertFalse((boolean)c1.isVarArgs());
        c1 = ConstructorUtils.getMatchingConstructor(ClassMultipleCtors.class, (Class[])new Class[]{Map.class, Integer.class});
    }
}

