package org.lsst.ccs.utilities.dsp;

import java.util.Arrays;

/**
 * 
 * @author aubourg
 * 
 */
public class MedianFilter implements DigitalFilter {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4525960504716400209L;

	public MedianFilter(int sz) {
		if (sz % 2 == 0) {
			sz++;
		}
		this.sz = sz;
		history = new double[sz];
		tmp = new double[sz];
	}

	public void reset() {
		Arrays.fill(history, 0);
		ip = 0;
	}

	public int getDelay() {
		return sz / 2;
	}

	public double flush() {
		return apply(0);
	}

	public double apply(double signal) {
		ip++;
		if (ip >= sz) {
			ip = 0;
		}
		history[ip] = signal;
		System.arraycopy(history, 0, tmp, 0, tmp.length);
		Arrays.sort(tmp);
		return tmp[sz / 2];
	}

	public double freqResp(double freq) {
		return 0;
	}

	public int getOrder() {
		return sz;
	}

	int sz;

	double[] history;

	double[] tmp;

	int ip;

	@Override
	public Object clone() {
		try {
			MedianFilter f = (MedianFilter) super.clone();
			f.history = new double[sz];
			f.tmp = new double[sz];
			return f;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}

}
