package org.lsst.ccs.utilities.network;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

/**
 *
 * @author The LSST CSS team
 */
public class NetworkUtils {

    /**
     * MAC address of the main Ethernet card
     * @return The Ethernet address of the main card.
     * 
     */
    public static String getEthHardAddress() {
        Enumeration<NetworkInterface> e;
        try {
            e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface itf = e.nextElement();
                if (!itf.isUp()) {
                    continue;
                }
                if (itf.isLoopback()) {
                    continue;
                }
                byte[] z = itf.getHardwareAddress();
                if (z == null) {
                    continue;
                }
                return String.format("%02x:%02x:%02x:%02x:%02x:%02x", z[0],
                        z[1], z[2], z[3], z[4], z[5]);
            }
        } catch (SocketException e1) {
        }
        return null;
    }

}
