/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.scheduler;

import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class PeriodicTaskTest {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGet_0args() throws Exception {
        Scheduler s = new Scheduler("tester", 2);
        AtomicInteger count1 = new AtomicInteger(0);
        PeriodicTask task1 = s.scheduleAtFixedRate(() -> count1.addAndGet(1), 0L, 100L, TimeUnit.MILLISECONDS);
        AtomicInteger count2 = new AtomicInteger(0);
        PeriodicTask task2 = s.scheduleAtFixedRate(() -> count2.addAndGet(1), 0L, 100L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.stop(), 200L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.start(), 300L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.cancel(false), 450L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)false, (Object)task2.isCancelled());
        Assert.assertEquals((Object)false, (Object)task2.isDone());
        try {
            task2.get();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        task1.cancel(false);
        s.schedule(() -> s.shutdown(), 1L, TimeUnit.SECONDS);
        try {
            s.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)count1.get());
        Assert.assertEquals((Object)true, (Object)task2.isCancelled());
        Assert.assertEquals((Object)true, (Object)task2.isDone());
    }

    @Test
    public void testGet_2args() throws Exception {
        Scheduler s = new Scheduler("tester", 2);
        AtomicInteger count1 = new AtomicInteger(0);
        PeriodicTask task1 = s.scheduleAtFixedRate(() -> count1.addAndGet(1), 0L, 100L, TimeUnit.MILLISECONDS);
        AtomicInteger count2 = new AtomicInteger(0);
        PeriodicTask task2 = s.scheduleAtFixedRate(() -> count2.addAndGet(1), 0L, 100L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.stop(), 150L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.start(), 200L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.setPeriod(50L, TimeUnit.MILLISECONDS), 250L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.stop(), 250L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.cancel(false), 450L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)false, (Object)task2.isCancelled());
        Assert.assertEquals((Object)false, (Object)task2.isDone());
        try {
            task2.get(700L, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        task1.cancel(false);
        s.schedule(() -> s.shutdown(), 1L, TimeUnit.SECONDS);
        try {
            s.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)count1.get());
        Assert.assertEquals((Object)true, (Object)task2.isCancelled());
        Assert.assertEquals((Object)true, (Object)task2.isDone());
    }

    @Test
    public void testSetPeriod() {
        Scheduler s = new Scheduler("tester", 2);
        AtomicInteger count1 = new AtomicInteger(0);
        PeriodicTask task1 = new PeriodicTask(s, () -> count1.addAndGet(1), true, "task 1", null, 100L, TimeUnit.MILLISECONDS);
        task1.start();
        s.schedule(() -> task1.setPeriod(200L, TimeUnit.MILLISECONDS), 150L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task1.cancel(false), 600L, TimeUnit.MILLISECONDS);
        AtomicInteger count2 = new AtomicInteger(0);
        PeriodicTask task2 = s.scheduleAtFixedRate(() -> count2.addAndGet(1), 0L, -1L, TimeUnit.MILLISECONDS, "task 2", null);
        s.schedule(() -> task2.setPeriod(100L, TimeUnit.MILLISECONDS), 200L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.setPeriod(0L, TimeUnit.MILLISECONDS), 250L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.setPeriod(200L, TimeUnit.MILLISECONDS), 400L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.cancel(false), 650L, TimeUnit.MILLISECONDS);
        s.schedule(() -> s.shutdown(), 1L, TimeUnit.SECONDS);
        try {
            s.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)count1.get());
        Assert.assertEquals((long)3L, (long)count2.get());
        Assert.assertEquals((long)200L, (long)task2.getPeriod(TimeUnit.MILLISECONDS));
    }

    @Test
    public void testSuspend_0args() {
        Scheduler s = new Scheduler("tester", 1);
        AtomicInteger count1 = new AtomicInteger(0);
        PeriodicTask task1 = s.scheduleAtFixedRate(() -> count1.addAndGet(1), 0L, 100L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task1.stop(), 150L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task1.start(), 400L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task1.cancel(false), 550L, TimeUnit.MILLISECONDS);
        AtomicInteger count2 = new AtomicInteger(0);
        PeriodicTask task2 = s.scheduleAtFixedRate(() -> count2.addAndGet(1), 0L, 100L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.stop(), 150L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.stop(), 150L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.setPeriod(200L, TimeUnit.MILLISECONDS), 200L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.start(), 500L, TimeUnit.MILLISECONDS);
        s.schedule(() -> task2.cancel(false), 650L, TimeUnit.MILLISECONDS);
        s.schedule(() -> s.shutdown(), 1L, TimeUnit.SECONDS);
        try {
            s.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)count1.get());
        Assert.assertEquals((long)3L, (long)count2.get());
    }

    @Test
    public void testMaxConsecutiveFailures() throws Exception {
        int maxConsecutiveFailures = 7;
        Scheduler s = new Scheduler("tester", 1);
        s.setMaxFailures(maxConsecutiveFailures);
        AtomicInteger countNonConsecutiveFailures = new AtomicInteger(0);
        PeriodicTask taskWithNonConsecutiveFailures = s.scheduleAtFixedRate(() -> {
            countNonConsecutiveFailures.addAndGet(1);
            int count = countNonConsecutiveFailures.get();
            if (count % 2 == 0) {
                throw new RuntimeException("exception");
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
        AtomicInteger countConsecutiveFailures = new AtomicInteger(0);
        PeriodicTask taskWithConsecutiveFailures = s.scheduleAtFixedRate(() -> {
            countConsecutiveFailures.addAndGet(1);
            throw new RuntimeException("exception");
        }, 0L, 100L, TimeUnit.MILLISECONDS);
        taskWithNonConsecutiveFailures.start();
        taskWithConsecutiveFailures.start();
        Thread.sleep(1000L);
        int nNonConsecutiveExecutions = countNonConsecutiveFailures.get();
        Assert.assertTrue((nNonConsecutiveExecutions > maxConsecutiveFailures ? 1 : 0) != 0);
        Assert.assertTrue((taskWithNonConsecutiveFailures.getFailures() <= 1 ? 1 : 0) != 0);
        Assert.assertTrue((countConsecutiveFailures.get() == maxConsecutiveFailures ? 1 : 0) != 0);
        Assert.assertTrue((taskWithConsecutiveFailures.getFailures() == maxConsecutiveFailures ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Assert.assertTrue((countNonConsecutiveFailures.get() > nNonConsecutiveExecutions ? 1 : 0) != 0);
        Assert.assertTrue((countConsecutiveFailures.get() == maxConsecutiveFailures ? 1 : 0) != 0);
        Assert.assertTrue((taskWithConsecutiveFailures.getFailures() == maxConsecutiveFailures ? 1 : 0) != 0);
        Assert.assertTrue((taskWithNonConsecutiveFailures.getFailures() <= 1 ? 1 : 0) != 0);
    }
}

