/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.scheduler;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class SchedulerTest {
    private static final Scheduler scheduler = new Scheduler("Scheduler test", 3);

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
        scheduler.shutdownNow();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLogging() {
        Scheduler s = new Scheduler("Logging test", 2);
        s.setMaxFailures(3);
        StringBuffer sb = new StringBuffer();
        s.schedule(() -> {
            sb.append("1");
            throw new RuntimeException("1");
        }, 0L, TimeUnit.SECONDS);
        s.schedule(() -> {
            sb.append("2");
            throw new RuntimeException("2");
        }, 0L, TimeUnit.SECONDS);
        s.scheduleWithFixedDelay(() -> {
            sb.append("3");
            throw new RuntimeException("3");
        }, 0L, 10L, TimeUnit.MILLISECONDS, "task 3", Level.ALL);
        s.schedule(() -> s.shutdown(), 1L, TimeUnit.SECONDS);
        try {
            s.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        char[] ca = sb.toString().toCharArray();
        Arrays.sort(ca);
        StringBuilder out = new StringBuilder(sb.length());
        for (char c : ca) {
            out.append(c);
        }
        Assert.assertEquals((Object)"12333", (Object)out.toString());
    }
}

