package org.lsst.ccs.utilities.logging;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/**
 * Filter that discards logs which level smaller than {@code Level.WARNING} and
 * coming from loggers other than "org.lsst.ccs.subsystem" or "org.lsst.ccs.driver".
 * Note that if the ConsoleHandler level is set to a level lower than {@code Level.INFO}
 * logs coming from other logger than the ones stated above will still
 * be discarded.
 * @author The LSST CCS Team
 */
public class UserConsoleFilter implements Filter {

    @Override
    public boolean isLoggable(LogRecord record) {
        if (record.getLoggerName().startsWith("org.lsst.ccs.subsystem") ||
                record.getLoggerName().startsWith("org.lsst.ccs.driver")){
            return true;
        } else 
            return record.getLevel().intValue() >= Level.WARNING.intValue();
    }
}
