/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.conv;

import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeConversionException;

public class InputConversionEngineTest
extends TestCase {
    private InputConversionEngine inputConversionEngine;
    private List<Integer> intList;
    private List<Double> doubleList;
    private List<String> stringList;
    private Set<Integer> intSet;
    private Set<Double> doubleSet;
    private Set<String> stringSet;
    private Map<Integer, String> intStringMap;

    public InputConversionEngineTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.inputConversionEngine = new InputConversionEngine();
    }

    public void testConvertArgToType() throws Exception {
        Object result = InputConversionEngine.convertArgToType((String)"1234", Integer.TYPE);
        InputConversionEngineTest.assertEquals((Object)1234, (Object)result);
    }

    public void testConvertArgToType2() throws Exception {
        Object result = InputConversionEngine.convertArgToType((String)"1234", Integer.class);
        InputConversionEngineTest.assertEquals((Object)1234, (Object)result);
    }

    public void testConvertArgToType3() throws Exception {
        Object result = InputConversionEngine.convertArgToType((String)"1234", Float.TYPE);
        InputConversionEngineTest.assertEquals((Object)Float.valueOf(1234.0f), (Object)result);
    }

    public void testConvertArgToType4() throws Exception {
        Object result = InputConversionEngine.convertArgToType((String)"1234", Double.TYPE);
        InputConversionEngineTest.assertEquals((Object)1234.0, (Object)result);
    }

    public void testConvertArgToType11() throws Exception {
        Object result = InputConversionEngine.convertArgToType((String)"TrUe", Boolean.TYPE);
        InputConversionEngineTest.assertEquals((Object)true, (Object)result);
    }

    public void testConvertArgToType5() throws Exception {
        Object result = InputConversionEngine.convertArgToType((String)"1234", String.class);
        InputConversionEngineTest.assertEquals((Object)"1234", (Object)result);
    }

    public void testConvertArgToType6() throws Exception {
        Object result = InputConversionEngine.convertArgToType((String)"1234", RandomObject.class);
        InputConversionEngineTest.assertEquals((String)"1234", (String)((RandomObject)result).getArg());
    }

    public void testConvertArgToType7() throws Exception {
        try {
            InputConversionEngine.convertArgToType((String)"1234", Random.class);
            InputConversionEngineTest.fail((String)"Should have thrown an exception");
        }
        catch (TypeConversionException x) {
            InputConversionEngineTest.assertEquals((String)"Error: Can't convert string '1234' to class java.util.Random", (String)x.getMessage());
        }
    }

    public void testConvertArgToType8() throws Exception {
        try {
            InputConversionEngine.convertArgToType((String)"4567", RandomObject.class);
            InputConversionEngineTest.fail((String)"Should have thrown an exception");
        }
        catch (TypeConversionException x) {
            InputConversionEngineTest.assertEquals((String)"Error: Can't instantiate class org.lsst.ccs.utilities.conv.InputConversionEngineTest$RandomObject using string '4567'", (String)x.getMessage());
        }
    }

    public void testConvertArgToType9() throws Exception {
        try {
            InputConversionEngine.convertArgToType((String)"1234", Boolean.TYPE);
            InputConversionEngineTest.fail((String)"Should have thrown an exception");
        }
        catch (TypeConversionException x) {
            InputConversionEngineTest.assertEquals((String)"Error: Can't convert string '1234' to Boolean", (String)x.getMessage());
        }
    }

    public void testConvertArgToType10() throws Exception {
        try {
            InputConversionEngine.convertArgToType((String)"1234.5", Integer.TYPE);
            InputConversionEngineTest.fail((String)"Should have thrown an exception");
        }
        catch (TypeConversionException x) {
            InputConversionEngineTest.assertEquals((String)"Error: Can't convert string '1234.5' to class int", (String)x.getMessage());
        }
    }

    public void testConvertArgToType12() throws Exception {
        String str = "2016-05-01T12:22:33.450Z";
        Object result = InputConversionEngine.convertArgToType((String)"2016-05-01T12:22:33.450Z", Instant.class);
        InputConversionEngineTest.assertEquals((Object)Instant.parse("2016-05-01T12:22:33.450Z"), (Object)result);
    }

    public void testConvertArgToType13() throws Exception {
        String str = "P1DT3M20S";
        Object result = InputConversionEngine.convertArgToType((String)"P1DT3M20S", Duration.class);
        InputConversionEngineTest.assertEquals((Object)Duration.parse("P1DT3M20S"), (Object)result);
    }

    public void testConvertArgToType14() throws Exception {
        try {
            InputConversionEngine.convertArgToType((String)"splunge", Instant.class);
            InputConversionEngineTest.fail((String)"Should have thrown an exception");
        }
        catch (TypeConversionException x) {
            InputConversionEngineTest.assertEquals((String)"Error: Can't convert string 'splunge' to class java.time.Instant", (String)x.getMessage());
        }
    }

    public void testConvertArgToType15() throws Exception {
        try {
            InputConversionEngine.convertArgToType((String)"splunge", Duration.class);
            InputConversionEngineTest.fail((String)"Should have thrown an exception");
        }
        catch (TypeConversionException x) {
            InputConversionEngineTest.assertEquals((String)"Error: Can't convert string 'splunge' to class java.time.Duration", (String)x.getMessage());
        }
    }

    public void testArrayConversion() throws Exception {
        int[] intArray = (int[])InputConversionEngine.convertArgToType((String)"[ 1, 3, 56 ]", int[].class);
        InputConversionEngineTest.assertTrue((intArray.length == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((int)intArray[0], (int)1);
        InputConversionEngineTest.assertEquals((int)intArray[1], (int)3);
        InputConversionEngineTest.assertEquals((int)intArray[2], (int)56);
        intArray = (int[])InputConversionEngine.convertArgToType((String)" [ 1,3, 56 ] ", int[].class);
        InputConversionEngineTest.assertTrue((intArray.length == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((int)intArray[0], (int)1);
        InputConversionEngineTest.assertEquals((int)intArray[1], (int)3);
        InputConversionEngineTest.assertEquals((int)intArray[2], (int)56);
        double[] doubleArray = (double[])InputConversionEngine.convertArgToType((String)"[ 1., 3., 56, 345, 7.223 ]", double[].class);
        InputConversionEngineTest.assertTrue((doubleArray.length == 5 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((Object)doubleArray[0], (Object)1.0);
        InputConversionEngineTest.assertEquals((Object)doubleArray[1], (Object)3.0);
        InputConversionEngineTest.assertEquals((Object)doubleArray[2], (Object)56.0);
        InputConversionEngineTest.assertEquals((Object)doubleArray[3], (Object)345.0);
        InputConversionEngineTest.assertEquals((Object)doubleArray[4], (Object)7.223);
        String[] stringArray = (String[])InputConversionEngine.convertArgToType((String)"[ 1., abc,dd#    ] ", String[].class);
        InputConversionEngineTest.assertTrue((stringArray.length == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((String)stringArray[0], (String)"1.");
        InputConversionEngineTest.assertEquals((String)stringArray[1], (String)"abc");
        InputConversionEngineTest.assertEquals((String)stringArray[2], (String)"dd#");
        int[] emptyArray = (int[])InputConversionEngine.convertArgToType((String)"[]", int[].class);
        InputConversionEngineTest.assertTrue((emptyArray.length == 0 ? 1 : 0) != 0);
    }

    public void testListConversion() throws Exception {
        this.intList = (List)InputConversionEngine.convertArgToType((String)"[1, 3, 56 ]", (Type)((Object)((Object)this)).getClass().getDeclaredField("intList").getGenericType());
        InputConversionEngineTest.assertTrue((this.intList.size() == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((int)this.intList.get(0), (int)1);
        InputConversionEngineTest.assertEquals((int)this.intList.get(1), (int)3);
        InputConversionEngineTest.assertEquals((int)this.intList.get(2), (int)56);
        this.doubleList = (List)InputConversionEngine.convertArgToType((String)"[ 1., 3., 56, 345, 7.223 ]", (Type)((Object)((Object)this)).getClass().getDeclaredField("doubleList").getGenericType());
        InputConversionEngineTest.assertTrue((this.doubleList.size() == 5 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((Object)this.doubleList.get(0), (Object)1.0);
        InputConversionEngineTest.assertEquals((Object)this.doubleList.get(1), (Object)3.0);
        InputConversionEngineTest.assertEquals((Object)this.doubleList.get(2), (Object)56.0);
        InputConversionEngineTest.assertEquals((Object)this.doubleList.get(3), (Object)345.0);
        InputConversionEngineTest.assertEquals((Object)this.doubleList.get(4), (Object)7.223);
        this.stringList = (List)InputConversionEngine.convertArgToType((String)"[ 1., abc,dd#    ] ", (Type)((Object)((Object)this)).getClass().getDeclaredField("stringList").getGenericType());
        InputConversionEngineTest.assertTrue((this.stringList.size() == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((String)this.stringList.get(0), (String)"1.");
        InputConversionEngineTest.assertEquals((String)this.stringList.get(1), (String)"abc");
        InputConversionEngineTest.assertEquals((String)this.stringList.get(2), (String)"dd#");
    }

    public void testSetConversion() throws Exception {
        this.intSet = (Set)InputConversionEngine.convertArgToType((String)"[1, 3, 56 ]", (Type)((Object)((Object)this)).getClass().getDeclaredField("intSet").getGenericType());
        InputConversionEngineTest.assertTrue((this.intSet.size() == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertTrue((boolean)this.intSet.contains(1));
        InputConversionEngineTest.assertTrue((boolean)this.intSet.contains(3));
        InputConversionEngineTest.assertTrue((boolean)this.intSet.contains(56));
        this.doubleSet = (Set)InputConversionEngine.convertArgToType((String)"[ 1., 3., 56, 345, 7.223 ]", (Type)((Object)((Object)this)).getClass().getDeclaredField("doubleSet").getGenericType());
        InputConversionEngineTest.assertTrue((this.doubleSet.size() == 5 ? 1 : 0) != 0);
        InputConversionEngineTest.assertTrue((boolean)this.doubleSet.contains(1.0));
        InputConversionEngineTest.assertTrue((boolean)this.doubleSet.contains(3.0));
        InputConversionEngineTest.assertTrue((boolean)this.doubleSet.contains(56.0));
        InputConversionEngineTest.assertTrue((boolean)this.doubleSet.contains(345.0));
        InputConversionEngineTest.assertTrue((boolean)this.doubleSet.contains(7.223));
        this.stringSet = (Set)InputConversionEngine.convertArgToType((String)"[ 1., abc,dd#    ] ", (Type)((Object)((Object)this)).getClass().getDeclaredField("stringSet").getGenericType());
        InputConversionEngineTest.assertTrue((this.stringSet.size() == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertTrue((boolean)this.stringSet.contains("1."));
        InputConversionEngineTest.assertTrue((boolean)this.stringSet.contains("abc"));
        InputConversionEngineTest.assertTrue((boolean)this.stringSet.contains("dd#"));
    }

    public void testMapConversion() throws Exception {
        this.intStringMap = (Map)InputConversionEngine.convertArgToType((String)"[1:some, 3:555, 56:43askdjf ]", (Type)((Object)((Object)this)).getClass().getDeclaredField("intStringMap").getGenericType());
        InputConversionEngineTest.assertTrue((this.intStringMap.keySet().size() == 3 ? 1 : 0) != 0);
        Set<Map.Entry<Integer, String>> entries = this.intStringMap.entrySet();
        InputConversionEngineTest.assertEquals((String)this.intStringMap.remove(1), (String)"some");
        InputConversionEngineTest.assertEquals((String)this.intStringMap.remove(3), (String)"555");
        InputConversionEngineTest.assertEquals((String)this.intStringMap.remove(56), (String)"43askdjf");
        this.intStringMap = (Map)InputConversionEngine.convertArgToType((String)"[]", (Type)((Object)((Object)this)).getClass().getDeclaredField("intStringMap").getGenericType());
        InputConversionEngineTest.assertTrue((boolean)this.intStringMap.isEmpty());
    }

    public void testSplittingGroupsWithBrackets() {
        String consoleInput = "[1, 3, 56 ]";
        List splits = InputConversionEngine.splitOnBrackets((String)consoleInput);
        InputConversionEngineTest.assertTrue((splits.size() == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((String)((String)splits.get(0)), (String)"1");
        InputConversionEngineTest.assertEquals((String)((String)splits.get(1)), (String)"3");
        InputConversionEngineTest.assertEquals((String)((String)splits.get(2)), (String)"56");
        consoleInput = " [  1 ,3,56 ]    ";
        splits = InputConversionEngine.splitOnBrackets((String)consoleInput);
        InputConversionEngineTest.assertEquals((int)splits.size(), (int)3);
        InputConversionEngineTest.assertEquals((String)((String)splits.get(0)), (String)"1");
        InputConversionEngineTest.assertEquals((String)((String)splits.get(1)), (String)"3");
        InputConversionEngineTest.assertEquals((String)((String)splits.get(2)), (String)"56");
        consoleInput = " [ [ 1 ],[3,56] ]    ";
        splits = InputConversionEngine.splitOnBrackets((String)consoleInput);
        InputConversionEngineTest.assertEquals((int)splits.size(), (int)2);
        List splits1 = InputConversionEngine.splitOnBrackets((String)((String)splits.get(0)));
        InputConversionEngineTest.assertEquals((int)splits1.size(), (int)1);
        InputConversionEngineTest.assertEquals((String)((String)splits1.get(0)), (String)"1");
        List splits2 = InputConversionEngine.splitOnBrackets((String)((String)splits.get(1)));
        InputConversionEngineTest.assertEquals((int)splits2.size(), (int)2);
        InputConversionEngineTest.assertEquals((String)((String)splits2.get(0)), (String)"3");
        InputConversionEngineTest.assertEquals((String)((String)splits2.get(1)), (String)"56");
    }

    private static class RandomObject {
        private final String arg;

        public RandomObject(String arg) {
            if (!"1234".equals(arg)) {
                throw new IllegalArgumentException("Illegal value " + arg);
            }
            this.arg = arg;
        }

        public String getArg() {
            return this.arg;
        }
    }
}

