package org.lsst.ccs.utilities.logging;

import java.util.logging.LogManager;

/**
 * A dedicated LockManager class to control the resetting of the LogManager when
 * a sigterm signal is received.
 * 
 * See https://jira.slac.stanford.edu/browse/LSSTCCS-1440
 * 
 * @author The LSST CCS Team
 */
public class CCSLogManager extends LogManager {

    static CCSLogManager instance;

    public CCSLogManager() { 
        if ( instance != null ) {
            throw new RuntimeException("CCS Log Manager already instanciated");
        }
        instance = this; 
    }


    @Override 
    public void reset() { 
    
    }
    
    private void internalReset() {
        super.reset();
    }

    public static void doReset() { 
        if ( instance != null ) {
            instance.internalReset(); 
        }
    }
    
    
}
