package org.lsst.ccs.utilities.constraints;

import org.apache.commons.beanutils.MethodUtils;

/**
 * A set of static methods to check constraints.
 *
 * @implNote
 * since this class depends heavily on Groovy it must be moved to gruth package.
 * @author bamade
 */
// Date: 31/05/12
public class Constraints {
    
    private Constraints() {
    }
    
    /**
     * Builds an object out of a type and a String representation and tests it against
     * the specified constraints.
     *
     * @param value the String representation of the object
     * @param constraints the constraints the final object must satisfy
     * @return an object that satisfies the constraints
     */
    public static void check(Object value, String constraints) {
        
        constraints = constraints.trim();
        
        if ("".equals(constraints)) {
            return;
        }
        
        // There is a constraint
        String[] split = constraints.split("\\.\\.");
        if (split.length == 2) {
            // constraint is a range
            checkRange(value.getClass(), value, split[0], split[1]);
        } else {
            throw new IllegalArgumentException("Could not process constraint " + constraints);
        }
    }
    
    /**
     * checks if the value of type is between lower and upper (included).
     *
     * @param thatClass a Class. the class <B>should</B> have a static factory method <TT>valueOf(String val)</TT>
     * (but <TT>java.lang.Character</TT> is still ok)
     * @param value
     * @param lower
     * @param upper
     * @return the real value
     */
    private static Object checkRange(Class thatClass, Object realValue, String lower, String upper) {
        try {
            Object realUpper = MethodUtils.invokeStaticMethod(thatClass, "valueOf", upper);
            Object realLower = MethodUtils.invokeStaticMethod(thatClass, "valueOf", lower);
            Comparable compValue = (Comparable) realValue;
            if ((compValue.compareTo(realLower) >= 0) && (compValue.compareTo(realUpper) <= 0)) {
                return realValue;
            } else {
                throw new IllegalArgumentException(realValue + "not in range [" + realLower + ".." + realUpper + "]");
            }
        } catch (Exception exc) {
            throw new IllegalArgumentException("range " + lower + ".." + upper
                    + " and value :" + realValue + " raises :" + exc);
        }
        
    }
    
}
