/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.lsst.ccs.utilities.beanutils.BeanFor;
import org.lsst.ccs.utilities.beanutils.BeanProxyFor;
import org.lsst.ccs.utilities.beanutils.CriticalCtor;
import org.lsst.ccs.utilities.beanutils.WrappedBeanMethodInvocationException;
import org.lsst.ccs.utilities.beanutils.WrappedException;

public abstract class BeanProxyFor<T>
implements BeanFor<T> {
    protected final ProxyAgent agent;
    protected T delegate;
    protected boolean methodsCalled;

    public BeanProxyFor() throws WrappedException {
        this.agent = new ProxyAgent();
    }

    public BeanProxyFor(T delegate) throws WrappedException {
        this.delegate = delegate;
        this.agent = new ProxyAgent();
    }

    @Override
    public T get() {
        return this.delegate;
    }

    protected class ProxyAgent {
        HashMap<String, org.lsst.ccs.utilities.beanutils.BeanProxyFor$ProxyAgent.Descriptor> delegateMethods = new HashMap();
        LinkedHashMap<String, org.lsst.ccs.utilities.beanutils.BeanProxyFor$ProxyAgent.Descriptor> ctorArgs = new LinkedHashMap();
        Constructor<T> minimumCtor;
        int nbArgsCtor;
        int nbArgsSet;

        ProxyAgent() {
            String beanName = BeanProxyFor.this.getClass().getCanonicalName();
            String className = beanName.replace("Bean", "");
            try {
                Constructor<?>[] constructors;
                Method[] methods;
                Class<?> klass = Class.forName(className);
                for (Method method : methods = klass.getMethods()) {
                    Descriptor descriptor;
                    String propertyName;
                    String name = method.getName();
                    if (name.startsWith("set")) {
                        propertyName = name.replace("set", "").toLowerCase();
                        descriptor = (Descriptor)this.delegateMethods.get(propertyName);
                        if (descriptor == null) {
                            descriptor = new Descriptor();
                            this.delegateMethods.put(propertyName, (org.lsst.ccs.utilities.beanutils.BeanProxyFor$ProxyAgent.Descriptor)descriptor);
                        }
                        descriptor.set = true;
                        descriptor.setMethod = method;
                        continue;
                    }
                    if (!name.startsWith("get")) continue;
                    propertyName = name.replace("get", "").toLowerCase();
                    descriptor = (Descriptor)this.delegateMethods.get(propertyName);
                    if (descriptor == null) {
                        descriptor = new Descriptor();
                        this.delegateMethods.put(propertyName, (org.lsst.ccs.utilities.beanutils.BeanProxyFor$ProxyAgent.Descriptor)descriptor);
                    }
                    descriptor.get = true;
                    descriptor.getMethod = method;
                }
                for (Constructor<?> constructor : constructors = klass.getConstructors()) {
                    CriticalCtor minimumDesc = constructor.getAnnotation(CriticalCtor.class);
                    if (minimumDesc == null) continue;
                    this.minimumCtor = constructor;
                    String[] names = minimumDesc.value();
                    this.nbArgsCtor = names.length;
                    this.ctorArgs = new LinkedHashMap(this.nbArgsCtor);
                    for (String name : names) {
                        Descriptor descriptor = new Descriptor();
                        descriptor.get = true;
                        descriptor.set = true;
                        this.ctorArgs.put(name.toLowerCase(), (org.lsst.ccs.utilities.beanutils.BeanProxyFor$ProxyAgent.Descriptor)descriptor);
                    }
                    return;
                }
            }
            catch (RuntimeException exc) {
                throw exc;
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean checkForDelegateCreation() {
            if (BeanProxyFor.this.delegate != null) {
                return false;
            }
            if (this.nbArgsCtor != this.nbArgsSet) return false;
            ArrayList<Object> listArgs = new ArrayList<Object>(this.nbArgsCtor);
            for (Descriptor descriptor : this.ctorArgs.values()) {
                listArgs.add(descriptor.value);
            }
            Object[] args = listArgs.toArray();
            try {
                BeanProxyFor.this.delegate = this.minimumCtor.newInstance(args);
                for (Descriptor descriptor : this.delegateMethods.values()) {
                    if (!descriptor.assigned || !descriptor.set) continue;
                    try {
                        descriptor.setMethod.invoke(BeanProxyFor.this.delegate, descriptor.value);
                    }
                    catch (Exception exc) {
                        throw new WrappedBeanMethodInvocationException(exc, descriptor.setMethod, descriptor.value);
                        return true;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new WrappedBeanMethodInvocationException(exception, this.minimumCtor, args);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setProperty(String proptyName, Object value) {
            BeanProxyFor.this.methodsCalled = true;
            String propertyName = proptyName.toLowerCase();
            if (BeanProxyFor.this.delegate == null) {
                Descriptor descriptor = (Descriptor)this.ctorArgs.get(propertyName);
                if (descriptor != null) {
                    descriptor.value = value;
                    if (!descriptor.assigned) {
                        ++this.nbArgsSet;
                    }
                    descriptor.assigned = true;
                    boolean created = this.checkForDelegateCreation();
                    if (!created) return;
                    return;
                }
                descriptor = (Descriptor)this.delegateMethods.get(propertyName);
                if (descriptor == null) throw new UnsupportedOperationException("set" + proptyName);
                descriptor.value = value;
                descriptor.assigned = true;
                return;
            }
            Descriptor descriptor = (Descriptor)this.delegateMethods.get(propertyName);
            if (descriptor == null || !descriptor.set) throw new UnsupportedOperationException("set" + proptyName);
            try {
                descriptor.setMethod.invoke(BeanProxyFor.this.delegate, value);
                return;
            }
            catch (Exception e) {
                throw new WrappedBeanMethodInvocationException(e, descriptor.setMethod, value);
            }
        }

        public Object getProperty(String proptyName) {
            BeanProxyFor.this.methodsCalled = true;
            String propertyName = proptyName.toLowerCase();
            if (BeanProxyFor.this.delegate == null) {
                Descriptor descriptor = (Descriptor)this.ctorArgs.get(propertyName);
                if (descriptor != null && descriptor.get) {
                    return descriptor.value;
                }
                descriptor = (Descriptor)this.delegateMethods.get(propertyName);
                if (descriptor != null && descriptor.get) {
                    return descriptor.value;
                }
                throw new UnsupportedOperationException("get" + proptyName);
            }
            Descriptor descriptor = (Descriptor)this.delegateMethods.get(propertyName);
            if (descriptor != null && descriptor.get) {
                try {
                    return descriptor.getMethod.invoke(BeanProxyFor.this.delegate, new Object[0]);
                }
                catch (Exception e) {
                    throw new WrappedBeanMethodInvocationException(e, descriptor.getMethod, new Object[0]);
                }
            }
            throw new UnsupportedOperationException("get" + proptyName);
        }

        class Descriptor {
            boolean get;
            boolean set;
            boolean assigned;
            Method setMethod;
            Method getMethod;
            Object value;

            Descriptor() {
            }

            public String toString() {
                return "get=" + this.get + ";set=" + this.set + ";assigned=" + this.assigned + (this.set ? ";" + this.setMethod.getName() : "") + (this.get ? ";" + this.getMethod.getName() : "");
            }
        }
    }
}

