package org.lsst.ccs.utilities.functions;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * a facility to create objects that are <TT>java.util.function</TT>
 * from FunctionalInterfaces (or closures) that throw an Exception.
 * Typical use can be:
 * <PRE>
 *     try {
 *          myArrayList.forEach(Cocoon.consumer(MyClass::methodThatThrowsMyException)) ;
 *
 *     } catch (MyException exc) {
 *
 *     }
 * </PRE>
 * note that if an exception is fired the forEach will be terminated.
 * @author bamade
 */
// Date: 03/10/2014

public class Cocoon {
    /**
     * this hack is to disable temporarily the compiler's control over checked exception.
     * <BB>use sparingly</BB>.
     * @param t
     * @param <T>
     * @return
     * @throws T
     */
    public static <T extends Throwable> T forgetThrowsClause(Throwable t) throws T{
        throw (T) t;
    }

    /**
     * creates an amiable <TT>Consumer</TT> out of a pesky one.
     * @param touchyConsumer
     * @param <X>
     * @param <T>
     * @return
     * @throws T
     */
    public static <X, T extends Throwable> Consumer<X> consumer(TouchyConsumer<X,T> touchyConsumer) throws T {
        Objects.requireNonNull(touchyConsumer);
        return new Consumer<X>() {
            @Override
            public void accept(X t) {
                try {
                    touchyConsumer.accept(t);
                } catch (Throwable exc) {
                    Cocoon.<RuntimeException>forgetThrowsClause(exc) ;
                }

            }
        } ;
    }

    public static <X,R,T extends Throwable> Function<X,R> function(TouchyFunction<X,R,T> touchyFunction) throws T {
        Objects.requireNonNull(touchyFunction);
        return new Function<X,R>() {

            @Override
            public R apply(X x) {
                try {
                   return touchyFunction.apply(x)  ;
                } catch(Throwable exc) {
                    Cocoon.<RuntimeException>forgetThrowsClause(exc) ;
                }
                assert true : "code in Coocon.function should not be executed" ;
                return null ;
            }
        } ;
    }

    public static <R, T extends Throwable> Supplier<R> supplier(TouchySupplier<R,T> touchySupplier)throws T  {
        Objects.requireNonNull(touchySupplier);
        return new Supplier<R>() {
            @Override
            public R get() {
                try {
                    return touchySupplier.get() ;
                }catch (Throwable exc){
                    Cocoon.<RuntimeException>forgetThrowsClause(exc) ;
                }
                assert true : "code in Coocon.supplier should not be executed" ;
                return null;
            }
        };
    }
}
