/*
 * Decompiled with CFR 0.152.
 */
package _test_dispatch_;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.util.concurrent.Future;
import org.lsst.ccs.utilities.dispatch.InvocationDispenser;
import org.lsst.ccs.utilities.dispatch.Invoker;

public class TztDispenser2 {
    PipedReader reader;
    PipedWriter writer;
    InvocationDispenser dispenser;
    String[][] events = new String[][]{{"_ABC", "event1"}, {"_DEF", "event2"}, {"_GHI", "event3"}};
    public Invoker eventInvoker = new Invoker(){

        public Object invoke(Object ... args) throws Exception {
            TztDispenser2.this.printEvent((String)args[0]);
            return null;
        }
    };

    public void printEvent(String name) {
        System.out.println("EVENT: " + name);
    }

    public String resString(String consumed) {
        return " RECEIVED " + consumed;
    }

    public TztDispenser2() throws IOException {
        this.reader = new PipedReader();
        this.writer = new PipedWriter(this.reader);
        this.dispenser = new InvocationDispenser();
        String[][] stringArray = this.events;
        int n = this.events.length;
        int n2 = 0;
        while (n2 < n) {
            String[] keyValue = stringArray[n2];
            this.dispenser.register(keyValue[0], this.eventInvoker);
            ++n2;
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                BufferedReader bufr = new BufferedReader(TztDispenser2.this.reader);
                int index = 0;
                try {
                    String read;
                    while ((read = bufr.readLine()) != null) {
                        String[] idCommand = read.split(",");
                        TztDispenser2.this.dispenser.callBack(idCommand[0], new Object[]{idCommand[1]});
                        Thread.sleep(100L);
                        int ix = index++ % TztDispenser2.this.events.length;
                        TztDispenser2.this.dispenser.call(TztDispenser2.this.events[ix][0], new Object[]{TztDispenser2.this.events[ix][1]});
                    }
                }
                catch (Exception exc) {
                    System.err.println("" + exc);
                }
            }
        };
        Thread thread = new Thread(runner);
        thread.start();
    }

    public String methodA(String arg) throws Exception {
        Invoker invoker = new Invoker(){

            public Object invoke(Object ... args) throws Exception {
                return args[0];
            }
        };
        String token = this.dispenser.generateToken();
        System.out.println("gen token :" + token);
        Future future = this.dispenser.registerFuture(token, invoker);
        this.writer.write(String.valueOf(token) + ',' + arg + "\n");
        this.writer.flush();
        String res = (String)future.get();
        return res;
    }

    public void close() {
        try {
            this.reader.close();
            this.writer.close();
        }
        catch (IOException e) {
            System.err.println("closing -> " + e);
        }
    }

    public static void main(String[] args) throws Exception {
        TztDispenser2 disp = new TztDispenser2();
        String res = disp.methodA("Hello");
        System.out.println("method A result :" + res);
        Thread.sleep(100L);
        res = disp.methodA("World");
        System.out.println("method A result :" + res);
        Thread.sleep(100L);
        disp.close();
    }
}

