package org.lsst.ccs.utilities.logging;


import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.lsst.ccs.utilities.tracers.Tracer;

/**
 * @author bamade
 * @deprecated Use standard FileHandler instead
 */
// Date: 29/07/13

@Deprecated
public class FileHandlerN extends FileHandler {
    public FileHandlerN() throws IOException, SecurityException {
        //super(getFilePattern());
    }

    public FileHandlerN(String pattern) throws IOException, SecurityException {
        super(pattern);
    }

    public FileHandlerN(String pattern, boolean append) throws IOException, SecurityException {
        super(pattern, append);
    }

    public FileHandlerN(String pattern, int limit, int count) throws IOException, SecurityException {
        super(pattern, limit, count);
    }

    public FileHandlerN(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        super(pattern, limit, count, append);
    }

    protected IsLoggableDelegate isLoggableDelegate = new IsLoggableDelegate();
    /**
     * NOTE : this is to hack a Java util logging bug!
     * BEWARE shpild be changed when BUG 9005710 is corrected!
     */
    protected IsLoggableDelegate isLoggableDelegate2 = new IsLoggableDelegate();

    @Override
    public boolean isLoggable(LogRecord record) {
        boolean res = super.isLoggable(record) ;
        if(! res) {return false ;}
        boolean delegateVal = isLoggableDelegate.isLoggable(record);
        if(delegateVal) return true ;
        assert Tracer.trace(record + " loggable ? " + res);
        return isLoggableDelegate2.isLoggable(record);
    }

    private static final int offValue = Level.OFF.intValue();

    /*
    private boolean handlerLoggable(LogRecord record) {
        int levelValue = getLevel().intValue();
        if (record.getLevel().intValue() < levelValue || levelValue == offValue) {
            return false;
        }
        Filter filter = getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isLoggable(record);
    }*/

    @Override
    public void publish(LogRecord record) {
        assert Tracer.trace("record to be written :" + record.getMessage());
        super.publish(record);
    }

    
    
}
