package org.lsst.ccs.utilities.structs;

/**
 * @author bamade
 */
// Date: 17/11/12

public class Pair<K,V> {
    public final K x ;
    public  V y ;

    public Pair(K x, V y) {
        this.x = x;
        this.y = y;
    }

    public K getX() {
        return x;
    }

    public V getY() {
        return y;
    }

    public void setX(V v) {
        this.y = v ;
    }

    @Override
    public String toString() {
        return "[" +x + ","+y +"]" ;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Pair)) return false;

        Pair pair = (Pair) o;

        if (!x.equals(pair.x)) return false;
        if (y != null ? !y.equals(pair.y) : pair.y != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = x.hashCode();
        result = 31 * result + (y != null ? y.hashCode() : 0);
        return result;
    }
}
