/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.tracers;

import java.util.Iterator;
import java.util.ServiceLoader;

public class Tracer {
    public static Strategy reporter;
    protected static String[] keys;

    static {
        String properties;
        ServiceLoader<Strategy> loader = ServiceLoader.load(Strategy.class);
        boolean found = false;
        try {
            Iterator<Strategy> iterator = loader.iterator();
            if (iterator.hasNext()) {
                Strategy rep;
                reporter = rep = iterator.next();
                found = true;
            }
        }
        catch (Exception exception) {}
        if (!found) {
            String className = System.getProperty("org.lsst.ccs.traceReporter");
            if (className == null) {
                reporter = new Strategy(){

                    @Override
                    public void report(String report) {
                        System.out.println(report);
                    }

                    @Override
                    public void addReportLine(String line) {
                        System.out.println(String.valueOf('\t') + line);
                    }

                    @Override
                    public void endReport() {
                    }
                };
            } else {
                try {
                    Class<?> clazz = Class.forName(className);
                    reporter = (Strategy)clazz.newInstance();
                }
                catch (Exception exc) {
                    throw new Error("incorrect class for trace configuration", exc);
                }
            }
        }
        keys = (properties = System.getProperty("org.lsst.ccs.traces")) != null ? properties.split(",") : new String[0];
    }

    public static void setReporter(Strategy reporter) {
        Tracer.reporter = reporter;
    }

    public static Strategy getReporter() {
        return reporter;
    }

    public static boolean trace(String traceString) {
        reporter.report(traceString);
        reporter.endReport();
        return true;
    }

    public static boolean trace(String filter, String traceString) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.equalsIgnoreCase(filter)) {
                reporter.report(traceString);
                reporter.endReport();
                return true;
            }
            ++n2;
        }
        return true;
    }

    public static <T extends Enum> boolean trace(T enumElement, String traceString) {
        return Tracer.trace(String.valueOf(enumElement), traceString);
    }

    public static boolean stackTrace() {
        Tracer.stackTrace(3);
        return true;
    }

    public static boolean stackTrace(String filter) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.equalsIgnoreCase(filter)) {
                Tracer.stackTrace(3);
                return true;
            }
            ++n2;
        }
        return true;
    }

    public static <T extends Enum> boolean stackTrace(T enumElement) {
        String filter = String.valueOf(enumElement);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.equalsIgnoreCase(filter)) {
                Tracer.stackTrace(1);
                return true;
            }
            ++n2;
        }
        return true;
    }

    protected static void stackTrace(int levelOut) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        reporter.report("-----------------");
        int ix = levelOut;
        while (ix < stack.length) {
            StackTraceElement element = stack[ix];
            reporter.addReportLine(element.toString());
            ++ix;
        }
        reporter.endReport();
    }

    public static class MultiReporter
    implements Strategy {
        Strategy[] strategies;

        public MultiReporter(Strategy ... strategies) {
            this.strategies = strategies;
        }

        @Override
        public void report(String report) {
            Strategy[] strategyArray = this.strategies;
            int n = this.strategies.length;
            int n2 = 0;
            while (n2 < n) {
                Strategy strategy = strategyArray[n2];
                strategy.report(report);
                ++n2;
            }
        }

        @Override
        public void addReportLine(String line) {
            Strategy[] strategyArray = this.strategies;
            int n = this.strategies.length;
            int n2 = 0;
            while (n2 < n) {
                Strategy strategy = strategyArray[n2];
                strategy.addReportLine(line);
                ++n2;
            }
        }

        @Override
        public void endReport() {
            Strategy[] strategyArray = this.strategies;
            int n = this.strategies.length;
            int n2 = 0;
            while (n2 < n) {
                Strategy strategy = strategyArray[n2];
                strategy.endReport();
                ++n2;
            }
        }
    }

    public static interface Strategy {
        public void report(String var1);

        public void addReportLine(String var1);

        public void endReport();
    }
}

