/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.sa;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Scanner;

public class CmndProcess {
    public static final int CMD_AMBIG = -2;
    public static final int CMD_UNKNOWN = -1;
    private static final PrintStream out = System.out;
    private LinkedList<Dispatch> disps = new LinkedList();
    private LinkedList<Command> cmnds = new LinkedList();
    private static final int CMD_HELPSUMM = 0;
    private static final int CMD_HELP = 1;
    private static final int CMD_EXIT = 2;
    private static final String[] helpHelp = new String[]{"Display help", "help  [<command>]", "command    Optional command for which help is wanted"};
    private static final String[] helpExit = new String[]{"Exit the program", "exit"};
    private static final String[] helpQuit = new String[]{"Exit the program", "quit"};
    private static final Command cmnd = new Command(4);
    private static final String[] typeDesc;

    public CmndProcess() {
        new Common();
    }

    public void add(Dispatch disp, Command cmnd) {
        for (int j = 0; j < cmnd.count(); ++j) {
            int code = this.findCmnd(cmnd.name(j));
            if (code < 0) continue;
            cmnd.disable(j);
        }
        this.disps.add(disp);
        this.cmnds.add(cmnd);
    }

    public boolean process(String line) {
        Scanner scan = new Scanner(line);
        if (!scan.hasNext()) {
            return true;
        }
        String command = scan.next().toLowerCase();
        int index = this.findCmnd(command);
        if (index < 0) {
            out.println((index == -1 ? "Unknown" : "Ambiguous") + " command (" + command + ")");
            return true;
        }
        int tIndex = index >> 16;
        int cIndex = index & 0xFFFF;
        Command cmd = this.cmnds.get(tIndex);
        int code = cmd.code(cIndex);
        String argDesc = cmd.argDesc(cIndex);
        Object[] args = new Object[argDesc.length()];
        int found = CmndProcess.scanArgs(scan, argDesc, cmd.lookup(cIndex), args);
        if (found < 0) {
            return true;
        }
        return this.disps.get(tIndex).dispatch(code, found, args);
    }

    private static int scanArgs(Scanner scan, String types, Lookup[] lookup, Object[] args) {
        int found = 0;
        int kInc = 0;
        int j = 0;
        int k = 0;
        while (j < types.length()) {
            block16: {
                block14: {
                    String arg;
                    int iType;
                    block18: {
                        boolean required;
                        block17: {
                            block15: {
                                String type = types.substring(j, j + 1);
                                String upType = type.toUpperCase();
                                required = type.equals(upType);
                                iType = "SBWILJKFDE".indexOf(upType);
                                if (iType < 0) {
                                    out.println("Invalid argument type specified (" + type + ")");
                                    return -1;
                                }
                                int n = kInc = iType == 5 || iType == 6 ? 1 : 0;
                                if (scan.hasNext()) break block15;
                                if (required) {
                                    out.println("Missing argument (" + (j + 1) + ")");
                                    return -1;
                                }
                                break block16;
                            }
                            if (iType != 9) break block17;
                            scan.skip(" *");
                            arg = scan.findInLine(".*");
                            break block18;
                        }
                        arg = scan.next();
                        if (!required && arg.equals("*")) break block16;
                    }
                    try {
                        if (iType == 0 || iType == 9) {
                            args[j] = arg;
                        } else if (iType < 6) {
                            long value = Long.decode(arg);
                            long sMask = -1L << (iType == 5 ? 32 : 1 << iType + 2);
                            long sBits = value & sMask;
                            if (value >= 0L && sBits != 0L || value < 0L && (sBits != sMask || value == sMask)) {
                                throw new NumberFormatException();
                            }
                            args[j] = iType == 1 ? (Number)((byte)value) : (Number)(iType == 2 ? (Number)((short)value) : (Number)(iType == 4 ? (Number)value : (Number)((int)value)));
                        } else {
                            if (iType == 6) {
                                throw new NumberFormatException();
                            }
                            args[j] = iType == 7 ? (Number)Float.valueOf(arg) : (Number)Double.valueOf(arg);
                        }
                    }
                    catch (NumberFormatException e) {
                        int value = -1;
                        if ((iType == 5 || iType == 6) && (value = lookup[k].encode(arg, false)) >= 0) {
                            args[j] = value;
                        }
                        if (value >= 0) break block14;
                        out.println((value == -1 ? "Invalid " : "Ambiguous ") + typeDesc[iType] + " argument (" + arg + ")");
                        return -1;
                    }
                }
                found |= 1 << j;
            }
            ++j;
            k += kInc;
        }
        if (scan.hasNext()) {
            out.println("Too many arguments");
            return -1;
        }
        return found;
    }

    private int findCmnd(String command) {
        int index = -1;
        int cIndx = 0;
        for (int j = 0; j < this.cmnds.size(); ++j) {
            int tIndex = this.cmnds.get(j).find(command);
            if (tIndex >= 0) {
                index = tIndex;
                cIndx = j;
                break;
            }
            if (tIndex == -2) {
                index = -2;
            }
            if (tIndex >= -2) continue;
            if (index == -1) {
                index = tIndex;
                cIndx = j;
                continue;
            }
            index = -2;
        }
        if (index < -2) {
            index = -3 - index;
        }
        if (index >= 0) {
            index |= cIndx << 16;
        }
        return index;
    }

    private void showHelpSumm(String command) {
        int j;
        int maxLeng = 0;
        for (j = 0; j < this.cmnds.size(); ++j) {
            int leng = this.cmnds.get(j).getMaxLeng(command);
            if (leng <= maxLeng) continue;
            maxLeng = leng;
        }
        for (j = 0; j < this.cmnds.size(); ++j) {
            this.cmnds.get(j).showHelpSumm(command, maxLeng);
        }
    }

    static {
        cmnd.add("help", 1, helpHelp, "s", new Lookup[0]);
        cmnd.add("?", 0, null, "", new Lookup[0]);
        cmnd.add("exit", 2, helpExit, "", new Lookup[0]);
        cmnd.add("quit", 2, helpQuit, "", new Lookup[0]);
        typeDesc = new String[]{"string", "byte", "short", "integer", "long", "keywdint", "keyword", "float", "double"};
    }

    private class Common
    implements Dispatch {
        public Common() {
            CmndProcess.this.add(this, cmnd);
        }

        @Override
        public boolean dispatch(int code, int found, Object[] args) {
            boolean cont = true;
            switch (code) {
                case 1: {
                    if (found != 0) {
                        String command = ((String)args[0]).toLowerCase();
                        int index = CmndProcess.this.findCmnd(command);
                        if (index >= 0) {
                            ((Command)CmndProcess.this.cmnds.get(index >> 16)).showHelp(index & 0xFFFF);
                            break;
                        }
                        if (index == -2) {
                            out.println("Matching commands are:");
                            CmndProcess.this.showHelpSumm(command);
                            break;
                        }
                        out.println("No matching commands");
                        break;
                    }
                }
                case 0: {
                    out.println("Valid commands are:");
                    CmndProcess.this.showHelpSumm(null);
                    break;
                }
                case 2: {
                    cont = false;
                }
            }
            return cont;
        }
    }

    public static class Lookup {
        private int nItem = 0;
        private String[] names;
        private int[] codes;

        public Lookup(int count) {
            this.codes = new int[count];
            this.names = new String[count];
        }

        public void add(String name, int code) {
            this.names[this.nItem] = name;
            this.codes[this.nItem] = code;
            ++this.nItem;
        }

        public int encode(String name, boolean report) {
            int index = 0;
            int match = 0;
            String lcName = name.toLowerCase();
            for (int j = 0; j < this.names.length; ++j) {
                String tName = this.names[j].toLowerCase();
                if (!tName.startsWith(lcName)) continue;
                index = j;
                ++match;
                if (!tName.equals(lcName)) continue;
                match = 1;
                break;
            }
            if (match == 1) {
                return this.codes[index];
            }
            if (report) {
                out.println((match == 0 ? "Unrecognized" : "Ambiguous") + " value: " + name);
            }
            return match == 0 ? -1 : -2;
        }

        public String decode(int code) {
            for (int j = 0; j < this.codes.length; ++j) {
                if (code != this.codes[j]) continue;
                return this.names[j];
            }
            return "Invalid";
        }

        public int count() {
            return this.nItem;
        }

        public int code(int index) {
            return this.codes[index];
        }

        public String name(int index) {
            return this.names[index];
        }
    }

    public static class Command {
        private int nCmnd = 0;
        private int[] cmdCode;
        private String[] cmdName;
        private String[] cmdArgDesc;
        private Lookup[][] cmdLookup;
        private String[][] cmdHelp;

        public Command(int count) {
            this.cmdCode = new int[count];
            this.cmdName = new String[count];
            this.cmdArgDesc = new String[count];
            this.cmdLookup = new Lookup[count][];
            this.cmdHelp = new String[count][];
        }

        public void add(String command, int code, String[] help, String argDesc, Lookup ... lookup) {
            this.cmdName[this.nCmnd] = command;
            this.cmdCode[this.nCmnd] = code;
            this.cmdHelp[this.nCmnd] = help;
            this.cmdArgDesc[this.nCmnd] = argDesc;
            this.cmdLookup[this.nCmnd] = lookup;
            ++this.nCmnd;
        }

        public int count() {
            return this.nCmnd;
        }

        public int find(String command) {
            int index = 0;
            int match = 0;
            for (int j = 0; j < this.nCmnd; ++j) {
                String name = this.cmdName[j];
                if (name == null || !name.startsWith(command)) continue;
                if (name.equals(command)) {
                    return j;
                }
                index = j;
                ++match;
            }
            if (match == 0) {
                return -1;
            }
            if (match > 1) {
                return -2;
            }
            return -3 - index;
        }

        public void disable(int index) {
            if (index >= 0) {
                this.cmdName[index] = null;
            }
        }

        public String name(int index) {
            return index >= 0 ? this.cmdName[index] : null;
        }

        public int code(int index) {
            return index >= 0 ? this.cmdCode[index] : index;
        }

        public String argDesc(int index) {
            return index >= 0 ? this.cmdArgDesc[index] : null;
        }

        public Lookup[] lookup(int index) {
            return index >= 0 ? this.cmdLookup[index] : null;
        }

        public String[] help(int index) {
            return index >= 0 ? this.cmdHelp[index] : null;
        }

        public void showHelp(int index) {
            String[] text = this.cmdHelp[index];
            if (text == null) {
                return;
            }
            out.println("Description:");
            out.println("  " + text[0]);
            out.println("Usage:");
            out.println("  " + text[1]);
            if (text.length > 2) {
                out.println("Parameters:");
            }
            for (int j = 2; j < text.length; ++j) {
                out.println("  " + text[j]);
            }
        }

        public int getMaxLeng(String command) {
            int maxLeng = 0;
            for (int j = 0; j < this.nCmnd; ++j) {
                String name = this.cmdName[j];
                if (name == null || command != null && !name.startsWith(command) || name.length() <= maxLeng) continue;
                maxLeng = name.length();
            }
            return maxLeng;
        }

        public void showHelpSumm(String command) {
            this.showHelpSumm(command, this.getMaxLeng(command));
        }

        public void showHelpSumm(String command, int maxLeng) {
            int j;
            StringBuilder blanks = new StringBuilder(maxLeng + 2);
            for (j = 0; j < blanks.capacity(); ++j) {
                blanks.append(" ");
            }
            for (j = 0; j < this.nCmnd; ++j) {
                String[] text;
                String name = this.cmdName[j];
                if (name == null || command != null && !name.startsWith(command) || (text = this.cmdHelp[j]) == null) continue;
                out.format("  %s%s%s\n", name, blanks.substring(name.length()), text[0]);
            }
        }
    }

    public static interface Dispatch {
        public boolean dispatch(int var1, int var2, Object[] var3);
    }
}

