/**
 * The Observer/observable pattern may come in different flavors offered by this package.
 * <P>
 * Primarily there are two main concerns addressed in the codes of this package:
 * <UL>
 *     <LI>
 *      Control over the parameter passed to method <TT>notifyObservers</TT>
 *      and received by <TT>update</TT> : this control is through the use of a parameterized type.
 *      At compile-time we can now check what is sent and what is received (named here the "protocol").
 *      <LI>
 *      Explicit specification  of the nature of code dispatching: "synchronous" means that the update
 *      codes of the Observer are executed in sequence and that the implementers are conscious that thus their code
 *      should terminate quickly; "parallel" means that the update codes are executed by different Threads.
 *      In both cases the nature of the update method is procedural (no return type) and exceptions are logged
 *      (they should not crash the system).
 *      <BR> TODO: change the logging to log4j
 * </UL>
 * So the "traditional" Observer/Observable pair can be replaced by <TT>SynchronousObserver</TT>
 * and <TT>SynchronousObservable</TT>. The main differences are:
 * <UL>
 *     <LI>
 *      method <TT>update</TT> takes no reference to the Observable (if you need one: create
 *      an <TT>Event</TT> like protocol that has a reference to the sender).
 *      <LI>
 *      method <TT>notifyObservers</TT> does not need a previous call to <TT>setChanged</TT>
 * </UL>
 *
 * If parallel processing is needed use instead <TT>ASyncObserver</TT>
 * and <TT>ParallelObservable</TT> .
 * <P>
 * Now why limit notifications to a single method? We may go through different methods....
 *
 * <P>
 * So there are two different patterns in this package to handle calls to different methods
 * for the registered agents:
 * <UL>
 *    <LI>
 *     Use of a <TT>Command</TT> pattern: see interfaces <TT>CommandFor</TT>, <TT>SynchronousCommandFor</TT>
 *     and Observable-like classes <TT>SynchronousCommandDispatcher</TT>, <TT>ParallelCommandDispatcher</TT>
 *
 *    <LI>
 *     Use of a <TT>Proxy</TT>: in that case the <TT>Observer</TT> classes should implement
 *     an interface class that is passed to a proxy generator
 *     (<TT>SynchronousDispatchProxy</TT> or <TT>ParallelDispatchProxy</TT>).
 *     These classes generate a very special object implementing the requested interface:
 *     a call to a method of this object is automatically forwarded to all the registered agents
 *     that implement the same interface.
 * </UL>
 *
 */
package  org.lsst.ccs.utilities.dispatch;