package org.lsst.ccs.utilities.conv;

/**
 ***************************************************************************
 **
 **  Routines for converting between numbers and byte sub-arrays
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class Convert {


   /**
    ***************************************************************************
    **
    **  Convert 4-byte little-endian subarray to integer
    **
    ***************************************************************************
    */
    public static int bytesToInt(byte[] ba, int ix)
    {
        return (ba[ix] & 0xff) | ((ba[ix + 1] & 0xff) << 8) |
               ((ba[ix + 2] & 0xff) << 16) | (ba[ix + 3] << 24);
    }


   /**
    ***************************************************************************
    **
    **  Convert 2-byte little-endian subarray to short
    **
    ***************************************************************************
    */
    public static short bytesToShort(byte[] ba, int ix)
    {
        return (short)((ba[ix] & 0xff) | (ba[ix + 1] << 8));
    }


   /**
    ***************************************************************************
    **
    **  Convert 4-byte little-endian subarray to float
    **
    ***************************************************************************
    */
    public static float bytesToFloat(byte[] ba, int ix)
    {
        int value = (ba[ix] & 0xff) | ((ba[ix + 1] & 0xff) << 8) |
                    ((ba[ix + 2] & 0xff) << 16) | (ba[ix + 3] << 24);
        return Float.intBitsToFloat(value);
    }


   /**
    ***************************************************************************
    **
    **  Convert integer to 4-byte little-endian subarray
    **
    ***************************************************************************
    */
    public static void intToBytes(int val, byte[] ba, int ix)
    {
        ba[ix]     = (byte)(val);
        ba[ix + 1] = (byte)(val >> 8);
        ba[ix + 2] = (byte)(val >> 16);
        ba[ix + 3] = (byte)(val >> 24);
    }


   /**
    ***************************************************************************
    **
    **  Convert short to 2-byte little-endian subarray
    **
    ***************************************************************************
    */
    public static void shortToBytes(short val, byte[] ba, int ix)
    {
        ba[ix]     = (byte)(val);
        ba[ix + 1] = (byte)(val >> 8);
    }


   /**
    ***************************************************************************
    **
    **  Convert float to 4-byte little-endian subarray
    **
    ***************************************************************************
    */
    public static void floatToBytes(float val, byte[] ba, int ix)
    {
        int value = Float.floatToIntBits(val);
        ba[ix]     = (byte)(value);
        ba[ix + 1] = (byte)(value >> 8);
        ba[ix + 2] = (byte)(value >> 16);
        ba[ix + 3] = (byte)(value >> 24);
    }


   /**
    ***************************************************************************
    **
    **  Convert integer to 4-byte big-endian subarray
    **
    ***************************************************************************
    */
    public static void intToBytesBE(int val, byte[] ba, int ix)
    {
        ba[ix]     = (byte)(val >> 24);
        ba[ix + 1] = (byte)(val >> 16);
        ba[ix + 2] = (byte)(val >> 8);
        ba[ix + 3] = (byte)(val);
    }

}
