package org.lsst.ccs.utilities.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * Super classes of all Bean "proxies" : that is class the offer a bean "vision"
 * of a non-bean class.
 * @author bamade
 */
public abstract class BeanProxyFor<T> implements BeanFor<T> {

    protected class ProxyAgent {
        class Descriptor {
            boolean get;
            boolean set;
            boolean assigned;
            Method setMethod;
            Method getMethod;
            Object value;
            public String toString(){
                return "get=" + get
                        + ";set=" + set
                        + ";assigned=" + assigned
                        + (set? ";" + setMethod.getName(): "")
                        + (get? ";" + getMethod.getName(): "") ;

            }
        }

        //TODO: put in a cache!
        HashMap<String, Descriptor> delegateMethods = new HashMap<String, Descriptor>();
        LinkedHashMap<String, Descriptor> ctorArgs = new LinkedHashMap<String, Descriptor>();
        Constructor<T> minimumCtor;
        int nbArgsCtor;
        int nbArgsSet;

        ProxyAgent() {
            String beanName = BeanProxyFor.this.getClass().getCanonicalName();
            String className = beanName.replace("Bean", "");
            try {
                Class klass = Class.forName(className);
                // first we scan the get and set of the object
                Method[] methods = klass.getMethods();
                for (Method method : methods) {
                    String name = method.getName();
                    if (name.startsWith("set")) {
                        String propertyName = name.replace("set", "").toLowerCase();
                        Descriptor descriptor = delegateMethods.get(propertyName);
                        if (descriptor == null) {
                            descriptor = new Descriptor();
                            delegateMethods.put(propertyName, descriptor);
                        }
                        descriptor.set = true;
                        descriptor.setMethod = method;

                    } else if (name.startsWith("get")) {
                        String propertyName = name.replace("get", "").toLowerCase();
                        Descriptor descriptor = delegateMethods.get(propertyName);
                        if (descriptor == null) {
                            descriptor = new Descriptor();
                            delegateMethods.put(propertyName, descriptor);
                        }
                        descriptor.get = true;
                        descriptor.getMethod = method;
                    }
                }
                //TODO: create bogus
                Constructor[] constructors = klass.getConstructors();
                for (Constructor constructor : constructors) {
                    CriticalCtor minimumDesc = (CriticalCtor) constructor.getAnnotation(CriticalCtor.class);
                    if (minimumDesc != null) {
                        this.minimumCtor = constructor;
                        String[] names = minimumDesc.value();
                        this.nbArgsCtor = names.length;
                        ctorArgs = new LinkedHashMap<String, Descriptor>(this.nbArgsCtor);
                        for (String name : names) {
                            Descriptor descriptor = new Descriptor();
                            descriptor.set = descriptor.get = true;
                            ctorArgs.put(name.toLowerCase(), descriptor);
                        }
                        return; //!!!!!!
                    }
                    //TODO: check what if no critical Ctor?
                }
                // then we create bogus get/set just for the bean and for use by minimum constructor
            } catch (Exception e) {
                throw new WrappedException(e);
            }
            //System.out.println(className);
        }

        /**
         * if all arguments in ctorArgs have been set then creates the delegate
         *
         * @return
         */

        private boolean checkForDelegateCreation() {
            if (delegate != null) return false;
            if (nbArgsCtor == nbArgsSet) {
                List<Object> listArgs = new ArrayList<Object>(nbArgsCtor);
                for (Descriptor desc : ctorArgs.values()) {
                    listArgs.add(desc.value);
                }
                Object[] args = listArgs.toArray();
                try {
                    delegate = minimumCtor.newInstance(args);
                    for (Descriptor descriptor : delegateMethods.values()) {
                    //System.out.println("-> " + descriptor);
                        if (descriptor.assigned && descriptor.set) {
                            try {
                                descriptor.setMethod.invoke(delegate, descriptor.value);
                            } catch (Exception exc) {
                                throw new WrappedBeanMethodInvocationException(
                                        exc, descriptor.setMethod, descriptor.value);  //CHANGE and get Logger
                            }
                        }
                    }
                } catch (Exception e) {
                    throw new WrappedBeanMethodInvocationException(e, minimumCtor, args);  //CHANGE and get Logger
                }
                return true;
            }
            return false;
        }

        /**
         * will consult ctorArgs:
         * if present and object not created -> assigns value
         * if all assigned create object
         * <p/>
         * consuls delegate methods
         * -> if present and object created -> forwards value
         * -> if present and not ctorArgs and not created -> assigns locally
         * -> else fails
         *
         * @param proptyName
         * @param value
         */
        public void setProperty(String proptyName, Object value) {
            methodsCalled = true;
            String propertyName = proptyName.toLowerCase();
            Descriptor descriptor;
            if (delegate == null) {
                // is it known as  a ctor argument?
                descriptor = ctorArgs.get(propertyName);
                if (descriptor != null) {
                    // if yes then
                    descriptor.value = value;
                    if (!descriptor.assigned) this.nbArgsSet++;
                    descriptor.assigned = true;
                    // we try to create the object
                    boolean created = checkForDelegateCreation();
                    if (created) return;
                } else {
                    descriptor = delegateMethods.get(propertyName);
                    if (descriptor != null) {
                        descriptor.value = value;
                        descriptor.assigned = true;
                    } else {
                        throw new UnsupportedOperationException("set" + proptyName);
                    }
                }

            } else { //object has been created
                descriptor = delegateMethods.get(propertyName);
                if ((descriptor != null) && descriptor.set) {
                    try {
                        descriptor.setMethod.invoke(delegate, value);
                    } catch (Exception e) {
                        throw new WrappedBeanMethodInvocationException(e, descriptor.setMethod, value);
                    }
                } else {
                    throw new UnsupportedOperationException("set" + proptyName);
                }

            }
        }

        public Object getProperty(String proptyName) {
            methodsCalled = true;
            String propertyName = proptyName.toLowerCase();

            Descriptor descriptor;
            if (delegate == null) {
                descriptor = ctorArgs.get(propertyName);
                if ((descriptor != null) && descriptor.get) { //get always true! bu who knows?
                    return descriptor.value;
                } else { //superfluous but clearer!
                    descriptor = delegateMethods.get(propertyName);
                    if ((descriptor != null) && descriptor.get) { //get always true! bu who knows?
                        return descriptor.value;
                    } else {
                        throw new UnsupportedOperationException("get" + proptyName);
                    }
                }

            } else {// object exists
                descriptor = delegateMethods.get(propertyName);
                if ((descriptor != null) && descriptor.get) { //get always true! bu who knows?
                    try {
                        return descriptor.getMethod.invoke(delegate);
                    } catch (Exception e) {
                        throw new WrappedBeanMethodInvocationException(e, descriptor.getMethod);
                    }
                } else {
                    throw new UnsupportedOperationException("get" + proptyName);
                }
            }
            //return null ;
        }
    }


    protected final ProxyAgent agent;
    protected T delegate;
    protected boolean methodsCalled;

    public BeanProxyFor() throws WrappedException {
        agent = new ProxyAgent();
    }

    public BeanProxyFor(T delegate) throws WrappedException {
        this.delegate = delegate;
        agent = new ProxyAgent();
    }

    public T get() {
        return this.delegate;
    }

}
