package org.lsst.ccs.utilities.dsp;

import java.util.Arrays;

/**
 * 
 * @author aubourg
 * 
 */
public class BoxCarFilter implements DigitalFilter {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6387011792246109318L;

	public BoxCarFilter(int sz) {
		this.sz = sz;
		history = new double[sz];
		current = 0;
		n = 0;
	}

	public void reset() {
		Arrays.fill(history, 0);
		ip = 0;
		current = 0;
		n = 0;
	}

	public int getDelay() {
		return sz / 2;
	}

	public double apply(double signal) {
		if (sz == 0)
			return signal;
		ip++;
		if (ip >= sz) {
			ip = 0;
		}
		n++;
		int used = n;
		if (used > sz) {
			used = sz;
		}
		if (n > sz) {
			current -= history[ip];
		}
		history[ip] = signal;
		current += signal;
		return current / used;
	}

	int flushed = -1;

	public double flush() {
		if (flushed == -1) {
			flushed = sz;
		}
		ip++;
		if (ip >= sz) {
			ip = 0;
		}
		current -= history[ip];
		flushed--;
		if (flushed == 0)
			throw new IllegalStateException();
		System.out.println("flushed " + flushed + " " + history[ip] + " "
				+ current / flushed);
		return current / flushed;
	}

	public double freqResp(double freq) {
		return 0;
	}

	public int getOrder() {
		return sz;
	}

	int sz;

	double[] history;

	double current;

	int ip;

	int n;

	@Override
	public Object clone() {
		try {
			BoxCarFilter f = (BoxCarFilter) super.clone();
			f.history = new double[sz];
			return f;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}

	public static void main(String[] args) {
		int sz = 25;
		int n = 200;
		double[] result = new double[n];
		BoxCarFilter f = new BoxCarFilter(sz);
		int d = f.getDelay();
		for (int i = 0; i < d; i++) {
			f.apply(i);
		}
		for (int i = 0; i < n - d; i++) {
			result[i] = f.apply(i + d);
		}
		for (int i = n - d; i < n; i++) {
			result[i] = f.flush();
		}
		for (int i = 0; i < n; i++) {
			System.out.println(i + "   " + result[i]);
		}

	}
}
