package org.lsst.ccs.utilities.dispatch;


import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;

/**
 * @author bernard AMADE
 */
class PackCst {
    public static final Logger CURLOG = Logger.getLogger(PackCst.class.getPackage().getName()) ;

    /**
     * All objects of this package may use the same Thread Pool.
     * (The Cached Thread Pool may be changed to fixed size)
     * <P>
     *     All Threads created here should be Daemons (has be changed)
     */
    static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(new ThreadFactory() {
        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            //thread.setDaemon(true);
            return thread;
        }
    });
}
