package org.lsst.ccs.utilities.tracers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;

/**
 * @author bamade
 */
// Date: 30/08/13

public class Names {
    public static final long LSST_EPOCH = new GregorianCalendar(2014,1,1).getTimeInMillis();
    /**
     * generates a (nearly) unique name for a given machine.
     * This can be used if one wants something more "readable" than a UUID
     * <B>But</B> since it uses a timestamp then calling this method in rapid succession
     * will generate the same name based on the same timestamp.
     *  this duplication could also happen if this method is called by two different process
     *  on the same machine.
     * So it is ok only to generate a name called once on a machine
     * @param seed any string including <TT>null</TT>
     * @return a concatenation of the seed, the machine name and a base 36 representation of the time
     */
    public static String almostUniqueAgentName(String seed) {
        String startName = (seed!= null)? seed + "_" : "" ;
        //concatenate system name
        String systemName;
        try {
           systemName= InetAddress.getLocalHost().getHostName();
        } catch (UnknownHostException e) {
            //TODO : getMachAddress
            systemName= "?" ;
        }
        // then time
        //String timeString = Long.toString(simpleTimestamp() , Character.MAX_RADIX) ;
        String timeString = toBase64String(simpleTimestamp()) ;
        return String.format("%s%s_%s",startName, systemName,timeString) ;
    }

    /**
     * same as <TT>uniqueAgentName(null)</TT>
     * @return
     */
    public static String almostUniqueAgentName() {
        return almostUniqueAgentName(null) ;
    }

    /**
     * can used to generate simple names based on a seed and a timestamp.
     * The string is not guaranteed unique if generated in rapid succession or in concurrent processes
     * @param seed any String (including <TT>null</TT>)
     * @return
     */
    public static String almostUniqueLocalName(String seed) {
        String startName = (seed!= null)? seed + "_" : "" ;
        //String timeString = Long.toString(simpleTimestamp() , Character.MAX_RADIX) ;
        String timeString = toBase64String(simpleTimestamp()) ;
        return String.format("%s%s",startName,timeString) ;
    }


    /**
     * returns a short timestamp starting from LSST_EPOCH
     * @return
     */
    public static long simpleTimestamp() {
        long timeStamp = System.currentTimeMillis() ;
        return timeStamp - LSST_EPOCH ;
    }
    private static final String base64code = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
            + "abcdefghijklmnopqrstuvwxyz" + "0123456789" + "_=";

    /**
     * transforms a long value in an (unconventional) base64 String
     * (it is not the standard base64 encoding but contains character '=' instead of '/')
     * @param val
     * @return
     */
    public static String toBase64String(long val) {
        StringBuffer stb = new StringBuffer() ;
        boolean negative = val < 0 ;
        if(negative) {
            val = - val ;
        }
        while(val > 0) {
            int modulo = (int) (val % 64) ;
            stb.insert(0,base64code.charAt(modulo)) ;
            val = val / 64 ;
        }
        return negative? "-" + stb.toString(): stb.toString() ;
    }
}
