package org.lsst.ccs.utilities.logging;

import java.util.Optional;

import java.awt.*;
import java.util.logging.*;

/**
 * Ths static initialization of this class should be fired early in utilities code by doing
 * <PRE>
 *     LogManagement.isConfigInitialized() ;
 * </PRE>
 * but this code is not necessary in application code (since the <TT>Logger</TT> calls
 * fire the load-time operation).
 *
 * @author bamade
 */
// Date: 31/05/13

public class LogManagement {
    static {
        Optional<LogManager> optManager =  LogPropertiesLoader.getSystemLoaderLogManager();
    }
    /**
     * a simple global <TT>ErrorManager</TT> that print logging framework problems to the console.
     * Should be changed to something that fires a network message
     */
    public static final ErrorManager ERROR_MANAGER = new ErrorManager();

    /**
     * dummy static method to fire the load-time operation.
     * // todo : get rid of that?
     * @return
     */
    public static boolean isConfigInitialized() {
        return true ;
    }

    /**
     * if a System Class Loader loads the standard LOgManager and the manager reads
     * the standard "loggin.properties" and initialize the Handlers we may end up with
     * two different Console Handlers.
     * For this purpose once we enter the realm of ccs.utilities we get rid of the
     * standard ConsoleHandler.
     * <BR/>
     * gets the top logger (name "") and removes the standard <TT>ConsoleHandler</TT>
     */
    //TODO: get rid of ALL ConsoleHandlers (inclusing those that are linked to specific Loggers ... un unlikely occurrence ... but who knows?
    public static Level cleanConsole() {
        //this is to get rid of other Consoles at the top
        java.util.logging.Logger globalHandler = java.util.logging.Logger.getLogger("");
        Handler[] handlers = globalHandler.getHandlers();
        // BEWARE used to know if ConsoleHandler was there!
        Level consoleLevel = null;
        for (Handler handler : handlers) {
            if (handler.getClass().equals(ConsoleHandler.class)) {
                consoleLevel = handler.getLevel();
                globalHandler.removeHandler(handler);
            }
        }
        return consoleLevel;
    }

    /**
     * to be used by some non-graphic codes
     * @param consoleLevel
     * //TODO: deprecate this method?
     */
    public static void setDefaultConsoleHandler(Level consoleLevel) {
        java.util.logging.Logger globalHandler = java.util.logging.Logger.getLogger("");
        if (consoleLevel != null && !GraphicsEnvironment.isHeadless()) {
            Handler consoleHandlerN = new ConsoleHandlerN();
            consoleHandlerN.setLevel(consoleLevel);
            globalHandler.addHandler(consoleHandlerN);
        }
    }


}
