package org.lsst.ccs.utilities.pattern;

import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

/**
 *
 * @author turri
 */
public class PatternUtils {
    
    /**
     * Resolves the pattern in input string using the following token resolution:
     * %W as defined in system property org.lsst.ccs.workdir, default is %h/ccs
     * %L as defined in system property org.lsst.ccs.logdir, default is %h
     * %A as defined by the name of the current Bootstrap Application, default is %u
     * %h is the user home directory as define by system property user.home
     * %t is a the temporary directory define by system property java.io.tmpdir
     * %u is the user name defined by system property user.name
     * 
     * @param input
     * @return The input string after the above patterns have been resolved.
     */

    public static String resolvePattern(String input) {

        Properties bootstrapSystemProperties = BootstrapResourceUtils.getBootstrapSystemProperties();
        if (input.contains("%W")) {
            String logdir = bootstrapSystemProperties.getProperty("org.lsst.ccs.workdir", "%h/ccs");
            input = input.replace("%W", logdir);
        }
        if (input.contains("%L")) {
            String logdir = bootstrapSystemProperties.getProperty("org.lsst.ccs.logdir", "%h");
            input = input.replace("%L", logdir);
        }
        if (input.contains("%A")) {
            String applicationName = bootstrapSystemProperties.getProperty("org.lsst.ccs.application.name", "%u");
            input = input.replace("%A", applicationName);
        }
        if (input.contains("%h")) {
            input = input.replace("%h", System.getProperty("user.home"));
        } 
        if (input.contains("%t")) {
            input = input.replace("%t", System.getProperty("java.io.tmpdir"));
        }
        if (input.contains("%u")) {
            input = input.replace("%u", System.getProperty("user.name"));
        }
        return input;
    }

}
