package org.lsst.ccs.utilities.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

import static org.lsst.ccs.utilities.tracers.Tracer.trace;

/**
 * A Console handler that detects duplicate logs.
 * <BR/>
 * This Handler systematically eliminates the standard <TT>ConsoleHandler</TT> that could be
 * running at the top of the hierarchy.
 *
 * @author bamade
 */
// Date: 29/05/13

public class ConsoleHandlerN extends ConsoleHandler {
    protected static final IsLoggableDelegate isLoggableDelegate = new IsLoggableDelegate();

    @Override
    public boolean isLoggable(LogRecord record) {
        assert trace("->" + record.getLoggerName() + " loggable?: " + super.isLoggable(record));
        return super.isLoggable(record) && isLoggableDelegate.isLoggable(record);
    }

    public ConsoleHandlerN() {
        LogManager logManager = LogManager.getLogManager();

        Level defaultLevel = LogManagement.cleanConsole();
            /*
            if (defaultLevel != null) {
                setLevel(defaultLevel);
            */
    }
}
