package org.lsst.ccs.utilities.functions;

/**
 * an Object whose final reference can be used by closure but that contains a modifiable value.
 * Tough Closures can use non-final variables (implicitly final) this makes sure everything is ok.
 * @author bamade
 */
// Date: 07/10/2014

public class MutableReference <T>{
    public T reference ;

    public MutableReference() {
    }

    public MutableReference(T reference) {
        this.reference = reference;
    }

    public T getReference() {
        return reference;
    }

    public void setReference(T reference) {
        this.reference = reference;
    }
}
