package org.lsst.ccs.utilities.dispatch;


import java.util.concurrent.CopyOnWriteArrayList;

/**
 * An <TT>Observable</TT> with protocol control at compile time.
 * The update are processed in sequence.
 *
 * @author bernard Amade
 */
public class SynchronousObservable<P> {
    protected CopyOnWriteArrayList<SynchronousObserver<P>> list = new java.util.concurrent.CopyOnWriteArrayList<SynchronousObserver<P>>() ;

    public void addObserver(SynchronousObserver<P> observer){
        this.list.add(observer);
    }

    public void removeObserver(SynchronousObserver<P> observer){
        this.list.remove (observer);
    }

    /**
     * do not need a call to <TT>setChanged</TT>: observers
     * are immediately notified.
     *
     * @param protocol
     */
    public void notifyObservers(P protocol) {
        for(SynchronousObserver<P> observer : list) {
            observer.update(protocol);
        }
    }
}
