/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.lsst.ccs.utilities.beanutils.Optional;
import org.lsst.ccs.utilities.logging.LogManagement;
import org.lsst.ccs.utilities.logging.LogPropertiesLoader;
import org.lsst.ccs.utilities.tracers.Tracer;

public class Logger {
    private java.util.logging.Logger julDelegate;
    protected ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread res = new Thread(r, "LoggerDelayedExecutor");
            res.setDaemon(true);
            return res;
        }
    });
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !Logger.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version("$Rev$", Logger.class, "org-lsst-ccs-utilities")) {
            throw new AssertionError();
        }
        LogManagement.isConfigInitialized();
    }

    private Logger(java.util.logging.Logger delegate) {
        this.julDelegate = delegate;
        Optional<LogManager> optManager = LogPropertiesLoader.getSystemLoaderLogManager();
        if (optManager.isPresent()) {
            LogManager manager = optManager.get();
            manager.addLogger(delegate);
        }
    }

    public static Logger getLogger(String name) {
        java.util.logging.Logger realLogger = java.util.logging.Logger.getLogger(name);
        return new Logger(realLogger);
    }

    public static Logger getLogger(String name, String resourceBundleName) {
        java.util.logging.Logger realLogger = java.util.logging.Logger.getLogger(name, resourceBundleName);
        return new Logger(realLogger);
    }

    public String getName() {
        return this.julDelegate.getName();
    }

    public Level getLevel() {
        return this.julDelegate.getLevel();
    }

    protected java.util.logging.Logger getParent() {
        return this.julDelegate.getParent();
    }

    public LogRecord createLogRecord(Level level, String message) {
        StackTraceElement[] stackTraceElements;
        LogRecord res = new LogRecord(level, message);
        StackTraceElement[] stackTraceElementArray = stackTraceElements = Thread.currentThread().getStackTrace();
        int n = stackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName;
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            String className = stackTraceElement.getClassName();
            if (!(className.startsWith("org.lsst.ccs.utilities.logging") || className.startsWith("org.apache.log4j") || className.contains(".logging.") || "getStackTrace".equals(methodName = stackTraceElement.getMethodName()))) {
                res.setSourceClassName(className);
                res.setSourceMethodName(methodName);
                break;
            }
            ++n2;
        }
        return res;
    }

    protected boolean logMessage(Level level, Object message, String ... concerns) {
        String msg = String.valueOf(message);
        LogRecord record = this.createLogRecord(level, msg);
        this.log(record, concerns);
        return true;
    }

    public boolean finest(Object message, String ... concerns) {
        return this.logMessage(Level.FINEST, message, concerns);
    }

    public boolean trace(Object message, String ... concerns) {
        return this.logMessage(Level.FINER, message, concerns);
    }

    public boolean finer(Object message, String ... concerns) {
        return this.logMessage(Level.FINER, message, concerns);
    }

    public boolean debug(Object message, String ... concerns) {
        return this.logMessage(Level.FINE, message, concerns);
    }

    public boolean fine(Object message, String ... concerns) {
        return this.logMessage(Level.FINE, message, concerns);
    }

    public boolean info(Object message, String ... concerns) {
        return this.logMessage(Level.INFO, message, concerns);
    }

    public boolean warn(Object message, String ... concerns) {
        return this.logMessage(Level.WARNING, message, concerns);
    }

    public boolean warning(Object message, String ... concerns) {
        return this.logMessage(Level.WARNING, message, concerns);
    }

    public void error(Object message, String ... concerns) {
        this.logMessage(Level.SEVERE, message, concerns);
    }

    public void fatal(Object message, String ... concerns) {
        this.logMessage(Level.SEVERE, message, concerns);
    }

    public void severe(Object message, String ... concerns) {
        this.logMessage(Level.SEVERE, message, concerns);
    }

    public boolean isDebugEnabled() {
        return this.julDelegate.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.julDelegate.isLoggable(Level.INFO);
    }

    protected void logSimpleThrowable(Level level, Object message, Throwable throwable, String ... concerns) {
        String msg = String.valueOf(message);
        LogRecord record = this.createLogRecord(level, msg);
        record.setThrown(throwable);
        this.log(record, concerns);
    }

    public void fatal(Object message, Throwable throwable, String ... concerns) {
        this.logSimpleThrowable(Level.SEVERE, message, throwable, concerns);
    }

    public void severe(Object message, Throwable throwable, String ... concerns) {
        this.logSimpleThrowable(Level.SEVERE, message, throwable, concerns);
    }

    public void error(Object message, Throwable throwable, String ... concerns) {
        this.logSimpleThrowable(Level.SEVERE, message, throwable, concerns);
    }

    public void warn(Object message, Throwable throwable, String ... concerns) {
        this.logSimpleThrowable(Level.WARNING, message, throwable, concerns);
    }

    public void warning(Object message, Throwable throwable, String ... concerns) {
        this.logSimpleThrowable(Level.WARNING, message, throwable, concerns);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable throwable) {
        this.julDelegate.throwing(sourceClass, sourceMethod, throwable);
    }

    public void info(Object message, Throwable throwable, String ... concerns) {
        this.logSimpleThrowable(Level.INFO, message, throwable, concerns);
    }

    public void debug(Object message, Throwable throwable, String ... concerns) {
        this.logSimpleThrowable(Level.FINE, message, throwable, concerns);
    }

    public boolean isLoggable(Level level) {
        return this.julDelegate.isLoggable(level);
    }

    public void log(LogRecord record, String ... concerns) {
        record.setLoggerName(this.julDelegate.getName());
        this.julDelegate.log(record);
        String[] stringArray = concerns;
        int n = concerns.length;
        int n2 = 0;
        while (n2 < n) {
            String concern = stringArray[n2];
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger(concern);
            record.setLoggerName(concern);
            logger.log(record);
            ++n2;
        }
    }

    public void decoupledLog(long delay, final LogRecord record, final String ... concerns) {
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                Logger.this.log(record, concerns);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    public boolean log(Level level, String message, Object argument, String ... concerns) {
        LogRecord record = this.createLogRecord(level, message);
        record.setParameters(new Object[]{argument});
        this.log(record, concerns);
        return true;
    }

    public boolean decoupledLog(long delay, Level level, String message, Object argument, String ... concerns) {
        LogRecord record = this.createLogRecord(level, message);
        record.setParameters(new Object[]{argument});
        this.decoupledLog(delay, record, concerns);
        return true;
    }

    public boolean log(Level level, String message, Object[] arguments, String ... concerns) {
        LogRecord record = this.createLogRecord(level, message);
        record.setParameters(arguments);
        this.log(record, concerns);
        return true;
    }

    public boolean decoupledLog(long delay, Level level, String message, Object[] arguments, String ... concerns) {
        LogRecord record = this.createLogRecord(level, message);
        record.setParameters(arguments);
        this.decoupledLog(delay, record, concerns);
        return true;
    }

    public void log(Level level, String message, Throwable throwable, String ... concerns) {
        LogRecord record = this.createLogRecord(level, message);
        record.setThrown(throwable);
        this.log(record, concerns);
    }

    public void decoupledLog(long delay, Level level, String message, Throwable throwable, String ... concerns) {
        LogRecord record = this.createLogRecord(level, message);
        record.setThrown(throwable);
        this.decoupledLog(delay, record, concerns);
    }

    @Deprecated
    public static void configure() {
    }
}

