package org.lsst.ccs.utilities.logging;

import java.io.OutputStream;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

/**:
 * A <TT>StreamHandler</TT> that detects duplicate publications.
 * @author bamade
 */
// Date: 29/05/13

public class StreamHandlerN extends StreamHandler{
    protected IsLoggableDelegate isLoggableDelegate = new IsLoggableDelegate();
    @Override
    public boolean isLoggable(LogRecord record) {
        return super.isLoggable(record) && isLoggableDelegate.isLoggable(record) ;
    }

    public StreamHandlerN() {
    }

    public StreamHandlerN(OutputStream out, Formatter formatter) {
        super(out, formatter);
    }
}
