package org.lsst.ccs.utilities.dispatch;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;

/**
 * An <TT>Observable</TT> that notifies <TT>Observers</TT>
 * through an <TT>ExecutorService</TT> (that is through different threads).
 *
 * @author bernard AMADE
 */
public class ParallelObservable<P> {
    protected CopyOnWriteArrayList<ASyncObserver<P>> list = new CopyOnWriteArrayList<ASyncObserver<P>>() ;

     static class DoUpdate<P2> implements Runnable {
        public final  ASyncObserver<P2> executant ;
        public final P2 data ;

        DoUpdate(ASyncObserver<P2> executant, P2 data) {
            this.executant = executant;
            this.data = data ;
        }

        @Override
        public void run() {
            try{
                executant.update(data);
            } catch (Exception exc) {
               PackCst.CURLOG.log(Level.SEVERE, "while executing :", exc);
            }
        }
    }


    /**
     *   ExecutorService that deals with the Threads handling the commands.
     */
    protected ExecutorService loop ;


    /**
     * Here the threads handling the updates are <TT>daemons</TT>.
     * You may change that by using a different constructor with another <TT>ExecutorService</TT>
     */
    public ParallelObservable() {
        this.loop = PackCst.EXECUTOR_SERVICE ;
    }

    public ParallelObservable(ExecutorService execService) {
        this.loop = execService ;
    }

     public void addObserver(ASyncObserver<P> observer){
        this.list.add(observer);
    }

    public void removeObserver(ASyncObserver<P> observer){
        this.list.remove (observer);
    }

    /**
     * do not need a call to <TT>setChanged</TT>: observers
     * are immediately notified through different threads
     *
     * @param data
     */
    public void notifyObservers(P data) {
        for(ASyncObserver<P> observer : list) {
            loop.submit(new DoUpdate<P>(observer, data)) ;
        }

    }
}
