package org.lsst.ccs.utilities.beanutils;

import java.lang.reflect.AccessibleObject;
import java.util.Arrays;

/**
 * Wraps an exception thrown while invoking a bean method delegated to a non-bean;
 * @author bamade
 */
public class WrappedBeanMethodInvocationException extends WrappedException {
    public final Object[] args ;
    public final transient  AccessibleObject method ;
    public final String methodString ;

    public WrappedBeanMethodInvocationException(Throwable throwable, AccessibleObject method, Object... args) {
        super(throwable);
        this.args = args;
        this.method = method;
        this.methodString = method.toString() ;
    }

    public String toString() {
        return super.toString() + " " + methodString + Arrays.toString(args)  ;
    }
}
