package org.lsst.ccs.utilities.logging;

import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

/**
 * @author bamade
 */
// Date: 15/04/2014

public class TextFormatter extends SimpleFormatter{
    String format ;
    private final Date dat = new Date();

    public TextFormatter() {
            format = ContextLogManager.loaderGetStringProperty("org.lsst.ccs.utilities.logging.TextFormatter.format", "%2$s:%5$s%n%6$s") ;
            StackTraceFormats.setDepthFromInitialProperties();
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public synchronized String format(LogRecord record) {
        //System.out.println(" depth" + StackTraceFormats.getDepth());
        String indexStr = String.valueOf(record.getSequenceNumber());

        dat.setTime(record.getMillis());
        String source;
        if (record.getSourceClassName() != null) {
            source = record.getSourceClassName();
            if (record.getSourceMethodName() != null) {
                source += " " + record.getSourceMethodName();
            }
        } else {
            source = record.getLoggerName();
        }
        String message = formatMessage(record);
        String throwableStr = "";
        Throwable throwable = record.getThrown() ;
        if (throwable != null) {
            throwableStr = StackTraceFormats.toString(throwable,1) ;
        }
        String res = indexStr + " " +String.format(format,
                dat,
                source,
                record.getLoggerName(),
                record.getLevel(),
                message,
                throwableStr);
        return res;
    }

}

