package org.lsst.ccs.utilities.logging;

/**
 * @author bamade
 */
// Date: 15/04/2014

public class StackTraceFormats {
    private static int depth = -1;
    private static volatile boolean modified = false;

    public static int getDepth() {
        return depth;
    }

    public static void setDepth(int depth) {
        StackTraceFormats.depth = depth;
        modified = true;
    }

    public static void setDepthFromInitialProperties() {
        if (modified) return;
        int depth = ContextLogManager.loaderGetIntProperty("StackTraceFormats.depth", -1);
        setDepth(depth);

    }

    public static String toString(Throwable throwable, int level) {
        StringBuilder stb = new StringBuilder(String.valueOf(throwable)).append('\n');
        StackTraceElement[] traces = throwable.getStackTrace();
        int size = traces.length;
        if ((depth < 0) || (size <= (depth * 2))) {
            for (StackTraceElement trace : traces) {
                indent(stb, level).append(trace).append('\n');
            }

        } else {
            for (int ix = 0; ix < depth; ix++) {
                indent(stb, level).append(traces[ix]).append('\n');
            }
            indent(stb, level).append(".....\n");
            for (int ix = size - (depth); ix < size; ix++) {
                indent(stb, level).append(traces[ix]).append('\n');
            }
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            indent(stb, level - 1).append("caused by : ").append(toString(cause, level + 1));
        }
        return stb.toString();
    }

    private static StringBuilder indent(StringBuilder stb, int level) {
        for (int ix = 0; ix <= level; ix++) {
            stb.append("  ");
        }
        return stb;
    }
}
