package org.lsst.ccs.utilities.jars;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

/**
 * @author bamade
 */
// Date: 15/05/13

public class MavenResources {
    /**
     * returns an URL for the <TT>pom.properties</TT> file linked to
     * a maven project.
     * <BR/>
     * It returns an array just in case there were many jars with the same projects
     * (an unlikely occurence!)
     *
     * @param org     the organisation (e.g. "org.lsst")
     * @param project such as "org-lsst-ccs-core"
     * @return
     */
    public static URL[] getPomURLs(String org, String project) {
        String path = "/META-INF/maven/" + org + "/" + project + "/pom.properties";
        return CommonResources.getURLsFrom(path);
    }

    /**
     * returns an URL for our specific <TT>$Project.maven.properties</TT> file linked to
     * a maven project.
     * <BR/>
     * It returns an array just in case there were many jars with the same projects
     * (an unlikely occurence!)
     *
     * @param project such as "org-lsst-ccs-core"
     * @return
     */
    public static URL[] getMavenProjectURLs(String project) {
        String path = project + ".maven.properties";
        return CommonResources.getURLsFrom(path);

    }

    /**
     * a facility method based on standard resource algorithm (it supposes there is only one jar
     * for the same project in the ClassPath).
     *
     * @param org     the organisation (e.g. "org.lsst")
     * @param project such as "org-lsst-ccs-core"
     * @return
     */
    public static Properties getPomProperties(String org, String project) {
        String path = "/META-INF/maven/" + org + "/" + project + "/pom.properties";
        Properties res = new Properties();
        try (InputStream is = MavenResources.class.getResourceAsStream(path)) {
            if (is != null) {
                res.load(is);
            }
        } catch (IOException e) {
            //TODO: log?
        }
        return res;
    }

    /**
     * a facility method to fetch our <TT>$Project.maven.properties</TT> based on standard resource algorithm (it supposes there is only one jar
     * for the same project in the ClassPath).
     *
     * @param project such as "org-lsst-ccs-core"
     * @return
     */
    public static Properties getMavenProjectProperties(String project) {
        String path = "/" + project + ".maven.properties";
        Properties res = new Properties();
        try (InputStream is = MavenResources.class.getResourceAsStream(path)) {
            if (is != null) {
                res.load(is);
            }
        } catch (IOException e) {
            //TODO log?
        }
        return res;
    }

}
