package org.lsst.ccs.utilities.scripting;

import java.util.concurrent.Future;

/**
 * THIS IS THROW AWAY CODE ONLY  NEEDED FOR THE SCRIPTING DISCUSSION.
 * This interface defines how a script interacts with a CCS Subsystem.
 */
public interface ScriptingSubsystemWrapper {

    /**
     * Invoke a synchronous command on the subsystem
     * @param timeout Number of seconds to wait for command completion. 
     *                Once the timeout is reached a ScriptingTimeoutException is thrown.
     * @param commandName The name of the command  to be executed. e.g. "takeImage"
     * @param args    Variable number of command arguments.
     * @return        The {@link ScriptingCommandResponse} containing the Object from the command execution
     *                It could be an exception if exceptions are set to be returned. 
     *                See {@link CCS#setThrowExceptions(boolean)}.
     * @throws ScriptingTimeoutException if exceptions are set to be thrown.
     */
    ScriptingCommandResponse invokeSynchronous(int timeout, String commandName, Object ... args) throws ScriptingTimeoutException;

    /**
     * Invoke a synchronous command on the subsystem
     * @param timeout Number of seconds to wait for command completion. 
     *                Once the timeout is reached a ScriptingTimeoutException is thrown.
     * @param command The name full command  to be executed, including the arguments. e.g. "takeImage 10 2"
     * @return        The {@link ScriptingCommandResponse} containing the Object from the command execution
     *                It could be an exception if exceptions are set to be returned.
     *                See {@link CCS#setThrowExceptions(boolean)}.
     * 
     * @throws ScriptingTimeoutException if exceptions are set to be thrown.
     */
    ScriptingCommandResponse invokeSynchronous(int timeout, String command) throws ScriptingTimeoutException;
    
    /**
     * Invoke an asynchronous command on the subsystem
     * @param commandName The name of the command  to be executed. e.g. "takeImage"
     * @param args    Variable number of command arguments.
     * @return A java.util.concurrent.Future that will contain the ScriptingCommandResponse 
     *         containing the Object resulted from the execution.
     *         The Future is returned only after the target subsystem has returned an Ack/nAck.
     *         The Object could be an Exception if exceptions are set to be returned.
     *         See {@link CCS#setThrowExceptions(boolean)}.
     * 
     */
    Future<ScriptingCommandResponse> invokeAsynchronous(String commandName, Object ... args);
    
    /**
     * Invoke an asynchronous command on the subsystem
     * @param command The name full command  to be executed, including the arguments. e.g. "takeImage 10 2"
     * @return A java.util.concurrent.Future that will contain the ScriptingCommandResponse 
     *         containing the Object resulted from the execution.
     *         The Future is returned only after the target subsystem has returned an Ack/nAck.
     *         The Object could be an Exception if exceptions are set to be returned.
     *                See {@link CCS#setThrowExceptions(boolean)}.
     * 
     */
    Future<ScriptingCommandResponse> invokeAsynchronous(String command);
    
        
}
