package org.lsst.ccs.utilities.scripting;

/**
 * THIS IS THROW AWAY CODE ONLY  NEEDED FOR THE SCRIPTING DISCUSSION.
 * Main scripting entry point to CCS.
 * 
 */
public interface CCS {
    
    /**
     * In the scripting environment, exceptions resulted from method invocation can either
     * be thrown or returned. Use this method to toggle between the two options.
     * 
     * @param throwExceptions boolean flag. If true exceptions will be thrown.
     * 
     */
    void setThrowExceptions(boolean throwExceptions);

    /**
     * Returns true if exceptions are thrown, otherwise they are returned as the
     * Object on the invoke methods.
     * 
     * @return true/false to indicate if exceptions are thrown/returned
     */
    boolean getThrowExceptions();
    
    
    /**
     * Creates and instance of a ScriptingSubsystemWrapper by making sure that the given subsystemName
     * corresponds to a CCS subsystem that is currently available, not locked and alive.
     * The process of creating the ScriptingSubsystemWrapper involves acquiring a lock on the subsystem.
     * Should we be able to specify the lock level?
     * 
     * 
     * @param subsystemName The name of the CCS subsystem. e.g. ccs-rafts.
     * @return              The ScriptingSubsystemWrapper representing the CCS subsystem
     * @throws RuntimeException 
     */
    ScriptingSubsystemWrapper attachSubsystem(String subsystemName) throws RuntimeException; 

    
}
