package org.lsst.ccs.utilities.logging;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.LogRecord;

/**
 * A utility to plug into Handlers that want to detect duplicate logs.
 * it keeps a list of the 32 last logs and return false to the <TT>isLoggable</TT> method
 * if a <TT>LogRecord</TT> with the same sequence number has been processed.
 * @author bamade
 */
// Date: 29/05/13

public class IsLoggableDelegate {
    private static final int MAX_ENTRIES = 32;
    private LinkedHashMap<Long, String> mapRecords =
            new LinkedHashMap<Long, String>(37){
                @Override
                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return size() > MAX_ENTRIES;
                }
            } ;
    //utiliser un linkedHashMap avec une taille limite
    public boolean isLoggable(LogRecord logRecord) {
        String logger = logRecord.getLoggerName();
        long seqNumber = logRecord.getSequenceNumber() ;
        return null == mapRecords.put(seqNumber,logger) ;
    }
}
