package org.lsst.ccs.utilities.dispatch;

/**
 * An <TT>Observer</TT> that knows that its code should terminate quickly because
 * it is invoked in sequence by the <TT>SynchronousObservable</TT>.
 *
 * @author  bernard AMADE
 */
public interface SynchronousObserver<P> {
    /**
     * Does not have an <TT>Observable</TT> parameter: use an <TT>Event</TT>
     * object as "protocol" if you need one.
     *
     * @param protocol
     */
    public void update(P protocol) ;
}
