package org.lsst.ccs.utilities.beanutils;

import java.lang.reflect.AccessibleObject;
import java.util.Arrays;

/**
 * Wraps an exception thrown while invoking a bean method delegated to a non-bean;
 * @author bamade
 */
public class WrappedBeanMethodInvocationException extends WrappedException {
    public final Object[] args ;
    public final AccessibleObject method ;

    public WrappedBeanMethodInvocationException(Throwable throwable, AccessibleObject method, Object... args) {
        super(throwable);
        this.args = args;
        this.method = method;
    }

    public String toString() {
        return super.toString() + " " + method + Arrays.toString(args)  ;
    }
}
