/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class SerializationTest {
    private static final long MILLIS = 1514764800000L;

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        CCSTimeStamp milliStamp = CCSTimeStamp.currentTimeFromMillis((long)1514764800000L);
        Object received = SerializationTest.serializeDeserialize(milliStamp);
        Assert.assertTrue((boolean)(received instanceof CCSTimeStamp));
        CCSTimeStamp ts = (CCSTimeStamp)received;
        Assert.assertEquals((double)ts.getUTCDouble(), (double)1.5147648E9, (double)1.0E-6);
        Assert.assertEquals((long)ts.getUTCInstant().getEpochSecond(), (long)1514764800L);
        Assert.assertEquals((long)37L, (long)Duration.between(ts.getUTCInstant(), ts.getTAIInstant()).getSeconds());
    }

    public void oldSerializationTest() throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(SerializationTest.class.getResourceAsStream("old.ser"));){
            Object received = ois.readObject();
            Assert.assertTrue((boolean)(received instanceof CCSTimeStamp));
            CCSTimeStamp ts = (CCSTimeStamp)received;
            Assert.assertEquals((double)ts.getUTCDouble(), (double)1.5147648E9, (double)1.0E-6);
            Assert.assertEquals((long)ts.getUTCInstant().getEpochSecond(), (long)1514764800L);
            Assert.assertEquals((long)37L, (long)Duration.between(ts.getUTCInstant(), ts.getTAIInstant()).getSeconds());
        }
    }

    static Object serializeDeserialize(Object in) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(in);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Object object = ois.readObject();
            return object;
        }
    }
}

