/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.io.IOException;
import java.net.URL;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.taitime.LeapSecondReader;

public class LeapSecondReaderTest {
    private static final long LAST_LEAP = 1483228800000L;
    private static final long FIRST_LEAP = 63072000000L;

    @Test
    public void testReadLocalFile() throws IOException {
        URL url = LeapSecondReaderTest.class.getResource("leap-seconds.list");
        LeapSecondReader reader = new LeapSecondReader(url);
        TreeMap leapMap = reader.getLeapMap();
        Assert.assertEquals((long)28L, (long)leapMap.size());
        Assert.assertEquals((long)63072000000L, (long)((Long)leapMap.firstKey()));
        Assert.assertEquals((long)1483228800000L, (long)((Long)leapMap.lastKey()));
        try {
            reader.getNumberOfLeapSeconds(63070000000L);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        int n = reader.getNumberOfLeapSeconds(63072000000L);
        Assert.assertEquals((long)10L, (long)n);
        n = reader.getNumberOfLeapSeconds(1483228799999L);
        Assert.assertEquals((long)36L, (long)n);
        n = reader.getNumberOfLeapSeconds(1483228800000L);
        Assert.assertEquals((long)37L, (long)n);
        n = reader.getNumberOfLeapSeconds(1483228800001L);
        Assert.assertEquals((long)37L, (long)n);
        Assert.assertEquals((long)1514419200000L, (long)reader.getExpiryDate());
        Assert.assertEquals((long)1467936000000L, (long)reader.getLastModificationDate());
    }

    @Test
    public void testReadRemoteFile() throws IOException {
        LeapSecondReader reader = new LeapSecondReader();
        TreeMap leapMap = reader.getLeapMap();
        assert (leapMap.size() >= 28);
        int n = reader.getNumberOfLeapSeconds(63072000000L);
        Assert.assertEquals((long)10L, (long)n);
        n = reader.getNumberOfLeapSeconds(1483228799999L);
        Assert.assertEquals((long)36L, (long)n);
        n = reader.getNumberOfLeapSeconds(1483228800000L);
        Assert.assertEquals((long)37L, (long)n);
        n = reader.getNumberOfLeapSeconds(1483228800001L);
        Assert.assertEquals((long)37L, (long)n);
    }

    @Test
    public void testReadBadFiles() throws IOException {
        try {
            URL url = LeapSecondReaderTest.class.getResource("bad-leap-seconds.list");
            LeapSecondReader reader = new LeapSecondReader(url);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testReadBadURL() throws IOException {
        try {
            LeapSecondReader reader = new LeapSecondReader(new URL("https://www.ietf.org/timezones/data/bad-leap-seconds.list"));
            Assert.fail((String)"Should not reach here");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testReadFromBootstrap() throws IOException {
        URL leapURL = BootstrapResourceUtils.getResourceURL((String)"leap-seconds.list");
        Assert.assertNotNull((String)"Missing leap-seconds.list file", (Object)leapURL);
        LeapSecondReader reader = new LeapSecondReader(leapURL);
        long expires = reader.getExpiryDate();
        Assert.assertTrue((String)"Built-in leap-seconds list has expired", (expires > System.currentTimeMillis() ? 1 : 0) != 0);
    }
}

