/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.time.Duration;
import java.time.Instant;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class NormalTest {
    @BeforeClass
    public static void setUpNormal() {
        System.clearProperty("org.lsst.ccs.utilities.taitime.libName");
        System.clearProperty("org.lsst.ccs.utilities.taitime.useStrict");
    }

    @Test
    public void normalTest() {
        CCSTimeStamp stamp = CCSTimeStamp.currentTime();
        Instant tai = stamp.getTAIInstant();
        Instant utc = stamp.getUTCInstant();
        long leapSeconds = Duration.between(utc, tai).getSeconds();
        Assert.assertTrue((String)("LeapSeconds " + leapSeconds + " should be greater than 30 "), (leapSeconds > 30L ? 1 : 0) != 0);
        Assert.assertTrue((String)("LeapSeconds " + leapSeconds + " should be less than 100 "), (leapSeconds < 100L ? 1 : 0) != 0);
    }

    @Test
    public void milliConstructorTest() {
        long millis = 1514764800000L;
        CCSTimeStamp milliStamp = CCSTimeStamp.currentTimeFromMillis((long)millis);
        Assert.assertEquals((double)milliStamp.getUTCDouble(), (double)((double)millis / 1000.0), (double)1.0E-6);
        Assert.assertEquals((long)milliStamp.getUTCInstant().getEpochSecond(), (long)(millis / 1000L));
        Assert.assertEquals((long)37L, (long)Duration.between(milliStamp.getUTCInstant(), milliStamp.getTAIInstant()).getSeconds());
    }
}

