/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.time.Duration;
import java.time.Instant;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class NonStrictTest {
    @Before
    public void setUpNonStrict() {
        System.setProperty("org.lsst.ccs.utilities.taitime.useStrict", "false");
        System.setProperty("org.lsst.ccs.utilities.taitime.libName", "badLibrary");
    }

    @Test
    public void nonStrictMode() {
        CCSTimeStamp stamp = CCSTimeStamp.currentTime();
        Instant tai = stamp.getTAIInstant();
        Instant utc = stamp.getUTCInstant();
        long leapSeconds = Duration.between(utc, tai).getSeconds();
        assert (leapSeconds > 30L && leapSeconds < 100L);
    }

    @Test
    public void milliConstructorTest() {
        Instant now = Instant.now();
        long millisNow = now.toEpochMilli();
        CCSTimeStamp milliStamp = CCSTimeStamp.currentTimeFromMillis((long)millisNow);
        assert ((double)now.toEpochMilli() - milliStamp.getUTCDouble() * 1000.0 <= 0.0);
        assert ((double)now.toEpochMilli() < milliStamp.getTAIDouble() * 1000.0);
    }
}

