/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.util.waitcursor;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.freehep.jas.util.waitcursor.WaitCursorEventQueue;

public class WaitCursorEventQueueTest
extends TestCase {
    private static final int TIMEOUT = 200;
    private static final int BUFFER = 30;
    private static final Cursor BASE_CURSOR = Cursor.getPredefinedCursor(1);
    private CursorReportingDialog dialog;
    private CursorReportingDialog dialog2;
    private CursorReportingFrame frame;
    private TestWaitCursorEventQueue eventQueue;

    public WaitCursorEventQueueTest(String name) {
        super(name);
    }

    public void setUp() {
        this.eventQueue = new TestWaitCursorEventQueue(200);
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this.eventQueue);
        this.frame = new CursorReportingFrame();
        this.frame.pack();
        this.frame.setBounds(-1000, -1000, 100, 100);
        this.frame.setVisible(true);
        this.dialog = new CursorReportingDialog(this.frame);
        this.dialog.pack();
        this.dialog.setBounds(-1000, -1000, 100, 100);
        this.dialog2 = new CursorReportingDialog(this.dialog);
        this.dialog2.pack();
        this.dialog2.setBounds(-1000, -1000, 100, 100);
    }

    public void tearDown() throws InvocationTargetException, InterruptedException {
        this.flushQueue();
        this.eventQueue.close();
        this.eventQueue = null;
        this.flushQueue();
        this.frame.dispose();
        this.frame = null;
        this.dialog.dispose();
        this.dialog = null;
    }

    public void testCursor() throws InvocationTargetException, InterruptedException {
        DelayEvent event = new DelayEvent(230);
        this.postEvent(this.frame, event);
        this.flushQueue();
        WaitCursorEventQueueTest.assertEquals((String)"1 cursor set", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"1 cursor reset", (int)1, (int)this.frame.getCursorResetCount());
    }

    public void testCursorAndDialog() throws InvocationTargetException, InterruptedException {
        TestRunnable testAndShow = new TestRunnable(){

            @Override
            public void run() {
                this.testsPassed &= 1 == WaitCursorEventQueueTest.this.frame.getCursorSetCount();
                this.testsPassed &= 0 == WaitCursorEventQueueTest.this.frame.getCursorResetCount();
                WaitCursorEventQueueTest.this.dialog.setVisible(true);
            }
        };
        this.postEvent(this.frame, new DelayEvent(230, testAndShow));
        this.flushQueue();
        WaitCursorEventQueueTest.assertTrue((String)"Delay worked", (boolean)testAndShow.getTestsPassed());
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got cursor", (int)0, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset cursor", (int)0, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got another cursor", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame reset cursor", (int)1, (int)this.frame.getCursorResetCount());
        this.postEvent(this.dialog, new DialogShowEvent(this.dialog, false, 0));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got cursor", (int)0, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset cursor", (int)0, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got another cursor", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never reset another cursor", (int)1, (int)this.frame.getCursorResetCount());
    }

    public void testCursorAndDialogAndCursor() throws InvocationTargetException, InterruptedException {
        TestRunnable testAndShow = new TestRunnable(){

            @Override
            public void run() {
                this.testsPassed &= 1 == WaitCursorEventQueueTest.this.frame.getCursorSetCount();
                this.testsPassed &= 0 == WaitCursorEventQueueTest.this.frame.getCursorResetCount();
                WaitCursorEventQueueTest.this.dialog.setVisible(true);
                WaitCursorEventQueueTest.this.hangOut(230L);
            }
        };
        this.postEvent(this.frame, new DelayEvent(230, testAndShow));
        this.flushQueue();
        WaitCursorEventQueueTest.assertTrue((String)"Delay worked", (boolean)testAndShow.getTestsPassed());
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got cursor", (int)0, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset cursor", (int)0, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got another cursor", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame reset cursor", (int)1, (int)this.frame.getCursorResetCount());
        this.postEvent(this.dialog, new DialogShowEvent(this.dialog, false, 0));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got cursor", (int)0, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset cursor", (int)0, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame got another cursor", (int)2, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame reset another cursor", (int)2, (int)this.frame.getCursorResetCount());
    }

    public void testCursorAndTwoDialogsAndCursor() throws InvocationTargetException, InterruptedException {
        this.postEvent(this.frame, new DialogShowEvent(this.dialog, true, 0));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got cursor", (int)0, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset cursor", (int)0, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got cursor", (int)0, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never reset cursor", (int)0, (int)this.frame.getCursorResetCount());
        TestRunnable testAndShow = new TestRunnable(){

            @Override
            public void run() {
                this.testsPassed &= 1 == WaitCursorEventQueueTest.this.dialog.getCursorSetCount();
                this.testsPassed &= 0 == WaitCursorEventQueueTest.this.dialog.getCursorResetCount();
                WaitCursorEventQueueTest.this.dialog2.setVisible(true);
                WaitCursorEventQueueTest.this.hangOut(230L);
            }
        };
        this.postEvent(this.dialog, new DelayEvent(230, testAndShow));
        this.flushQueue();
        WaitCursorEventQueueTest.assertTrue((String)"Delay worked", (boolean)testAndShow.getTestsPassed());
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never got cursor", (int)0, (int)this.dialog2.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never reset cursor", (int)0, (int)this.dialog2.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got another cursor", (int)1, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog reset cursor", (int)1, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got cursor", (int)0, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never reset cursor", (int)0, (int)this.frame.getCursorResetCount());
        this.postEvent(this.dialog2, new DialogShowEvent(this.dialog2, false, 0));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never got cursor", (int)0, (int)this.dialog2.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never reset cursor", (int)0, (int)this.dialog2.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog got another cursor", (int)2, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog reset another cursor", (int)2, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got cursor", (int)0, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never reset cursor", (int)0, (int)this.frame.getCursorResetCount());
        this.postEvent(this.dialog, new DialogShowEvent(this.dialog, false, 0));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never got cursor", (int)0, (int)this.dialog2.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never reset cursor", (int)0, (int)this.dialog2.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got another cursor", (int)2, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset another cursor", (int)2, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got cursor", (int)0, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never reset cursor", (int)0, (int)this.frame.getCursorResetCount());
    }

    public void testDelayedGetNextEvent() throws InvocationTargetException, InterruptedException {
        this.postEvent(this.frame, new DialogShowEvent(this.dialog, true, 0));
        this.flushQueue();
        this.hangOut(230L);
        this.eventQueue.setGetDelay(230);
        this.postEvent(this.frame, new DelayEvent(170));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"frame got a cursor", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame reset a cursor", (int)1, (int)this.frame.getCursorResetCount());
        this.postEvent(this.dialog, new DialogShowEvent(this.dialog, false, 0));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"frame did not get another cursor", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame did not reset another cursor", (int)1, (int)this.frame.getCursorResetCount());
    }

    public void testDialog() throws InvocationTargetException, InterruptedException {
        this.postEvent(this.frame, new DialogShowEvent(this.dialog, true, 0));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got cursor", (int)0, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset cursor", (int)0, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got cursor", (int)0, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never reset cursor", (int)0, (int)this.frame.getCursorResetCount());
        this.postEvent(this.dialog, new DialogShowEvent(this.dialog, false, 0));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got cursor", (int)0, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset cursor", (int)0, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got cursor", (int)0, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never reset cursor", (int)0, (int)this.frame.getCursorResetCount());
    }

    public void testNoCursor() throws InvocationTargetException, InterruptedException {
        DelayEvent event = new DelayEvent(170);
        this.postEvent(this.frame, event);
        this.postEvent(this.frame, event);
        this.postEvent(this.frame, event);
        this.postEvent(this.frame, event);
        this.flushQueue();
        WaitCursorEventQueueTest.assertEquals((String)"no cursor set", (int)0, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"no cursor reset", (int)0, (int)this.frame.getCursorResetCount());
    }

    public void testTwoDialogs() throws InvocationTargetException, InterruptedException {
        TestRunnable testAndShow = new TestRunnable(){

            @Override
            public void run() {
                this.testsPassed &= 1 == WaitCursorEventQueueTest.this.frame.getCursorSetCount();
                this.testsPassed &= 0 == WaitCursorEventQueueTest.this.frame.getCursorResetCount();
                WaitCursorEventQueueTest.this.dialog.setVisible(true);
            }
        };
        this.postEvent(this.frame, new DelayEvent(230, testAndShow));
        this.flushQueue();
        WaitCursorEventQueueTest.assertTrue((String)"Delay worked", (boolean)testAndShow.getTestsPassed());
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got cursor", (int)0, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset cursor", (int)0, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got another cursor", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame reset cursor", (int)1, (int)this.frame.getCursorResetCount());
        TestRunnable testAndShow2 = new TestRunnable(){

            @Override
            public void run() {
                this.testsPassed &= 1 == WaitCursorEventQueueTest.this.dialog.getCursorSetCount();
                this.testsPassed &= 0 == WaitCursorEventQueueTest.this.dialog.getCursorResetCount();
                WaitCursorEventQueueTest.this.dialog2.setVisible(true);
            }
        };
        this.postEvent(this.dialog, new DelayEvent(230, testAndShow2));
        this.flushQueue();
        WaitCursorEventQueueTest.assertTrue((String)"Delay worked", (boolean)testAndShow.getTestsPassed());
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never got cursor", (int)0, (int)this.dialog2.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never reset cursor", (int)0, (int)this.dialog2.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got another cursor", (int)1, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog reset cursor", (int)1, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got another cursor", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame reset cursor", (int)1, (int)this.frame.getCursorResetCount());
        this.postEvent(this.dialog2, new DelayEvent(230));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 got cursor", (int)1, (int)this.dialog2.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 reset cursor", (int)1, (int)this.dialog2.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got another cursor", (int)1, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog reset cursor", (int)1, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got another cursor", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame reset cursor", (int)1, (int)this.frame.getCursorResetCount());
        this.postEvent(this.dialog2, new DialogShowEvent(this.dialog2, false, 0));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never got another cursor", (int)1, (int)this.dialog2.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never reset another cursor", (int)1, (int)this.dialog2.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got another cursor", (int)1, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset another cursor", (int)1, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got another cursor", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never reset another cursor", (int)1, (int)this.frame.getCursorResetCount());
        this.postEvent(this.dialog, new DialogShowEvent(this.dialog, false, 0));
        this.flushQueue();
        this.hangOut(230L);
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never got another cursor", (int)1, (int)this.dialog2.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog2 never reset another cursor", (int)1, (int)this.dialog2.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never got another cursor", (int)1, (int)this.dialog.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"dialog never reset another cursor", (int)1, (int)this.dialog.getCursorResetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never got another cursor", (int)1, (int)this.frame.getCursorSetCount());
        WaitCursorEventQueueTest.assertEquals((String)"frame never reset another cursor", (int)1, (int)this.frame.getCursorResetCount());
    }

    private void flushQueue() throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void hangOut(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void postEvent(Object source, Runnable event) {
        this.eventQueue.postEvent(new InvocationEvent(source, event));
    }

    private class CursorReportingDialog
    extends Dialog {
        private int cursorResetCount;
        private int cursorSetCount;

        public CursorReportingDialog(Frame owner) {
            super(owner, true);
            this.init();
        }

        public CursorReportingDialog(Dialog owner) {
            super(owner, "", true);
            this.init();
        }

        @Override
        public void setCursor(Cursor cursor) {
            super.setCursor(cursor);
            if (BASE_CURSOR.equals(cursor)) {
                ++this.cursorResetCount;
            } else {
                ++this.cursorSetCount;
            }
        }

        public int getCursorResetCount() {
            return this.cursorResetCount;
        }

        public int getCursorSetCount() {
            return this.cursorSetCount;
        }

        private void init() {
            this.setCursor(BASE_CURSOR);
            this.cursorSetCount = 0;
            this.cursorResetCount = 0;
        }
    }

    private class CursorReportingFrame
    extends Frame {
        private int cursorResetCount;
        private int cursorSetCount;

        public CursorReportingFrame() {
            this.setCursor(BASE_CURSOR);
            this.cursorSetCount = 0;
            this.cursorResetCount = 0;
        }

        @Override
        public void setCursor(Cursor cursor) {
            super.setCursor(cursor);
            if (BASE_CURSOR.equals(cursor)) {
                ++this.cursorResetCount;
            } else {
                ++this.cursorSetCount;
            }
        }

        public int getCursorResetCount() {
            return this.cursorResetCount;
        }

        public int getCursorSetCount() {
            return this.cursorSetCount;
        }
    }

    private class TestWaitCursorEventQueue
    extends WaitCursorEventQueue {
        private int getDelay;

        public TestWaitCursorEventQueue(int delay) {
            super(delay);
        }

        public void setGetDelay(int getDelay) {
            this.getDelay = getDelay;
        }

        @Override
        public AWTEvent getNextEvent() throws InterruptedException {
            if (this.getDelay > 0) {
                WaitCursorEventQueueTest.this.hangOut(this.getDelay);
                this.getDelay = 0;
            }
            return super.getNextEvent();
        }
    }

    private class DelayEvent
    implements Runnable {
        private Runnable callback;
        private int delay;

        public DelayEvent(int delay) {
            this(delay, null);
        }

        public DelayEvent(int delay, Runnable callback) {
            this.delay = delay;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }

    private abstract class TestRunnable
    implements Runnable {
        protected boolean testsPassed = true;

        private TestRunnable() {
        }

        public boolean getTestsPassed() {
            return this.testsPassed;
        }
    }

    private class DialogShowEvent
    implements Runnable {
        private Dialog dialog;
        private boolean visible;
        private int delay;

        public DialogShowEvent(Dialog dialog, boolean visible, int delay) {
            this.dialog = dialog;
            this.visible = visible;
            this.delay = delay;
        }

        @Override
        public void run() {
            this.dialog.setVisible(this.visible);
            if (this.delay > 0) {
                WaitCursorEventQueueTest.this.hangOut(this.delay);
            }
        }
    }
}

