/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.freehep.application.Application;
import org.freehep.application.RecentItemTextField;

public class OpenLocalFilePanel
extends JPanel {
    private String m_lastLocalDirectory_Key;
    private RecentItemTextField m_fileName;
    private JButton m_browse;
    private JButton m_view = null;
    private JCheckBox m_gzip = null;
    private Application app = Application.getApplication();
    private final Properties m_prop = this.app == null ? new Properties() : this.app.getUserProperties();
    private FileFilter m_filter = null;
    private MyListener listener = new MyListener();
    private boolean wasEnabled = false;
    private ChangeEvent event = new ChangeEvent(this);

    public OpenLocalFilePanel(String key, FileFilter filter, boolean includePreviewButton, boolean includeGZIP) {
        this(key, includePreviewButton, includeGZIP);
        this.m_filter = filter;
    }

    public OpenLocalFilePanel(String key, boolean includePreviewButton, boolean includeGZIP) {
        this.m_lastLocalDirectory_Key = key + "-directory";
        this.m_fileName = new RecentItemTextField(key + "-files", 4, true);
        this.m_fileName.setMinWidth(250);
        this.m_fileName.setMaxWidth(250);
        this.m_fileName.addChangeListener((ChangeListener)this.listener);
        this.add((Component)this.m_fileName);
        this.m_browse = new JButton("Browse...");
        this.m_browse.addActionListener(this.listener);
        this.m_browse.setMnemonic('B');
        this.add(this.m_browse);
        if (includePreviewButton) {
            this.m_view = new JButton("Preview");
            this.m_view.addActionListener(this.listener);
            this.m_view.setMnemonic('V');
            this.add(this.m_view);
            this.m_view.setEnabled(false);
        }
        if (includeGZIP) {
            this.m_gzip = new JCheckBox("GZIPed");
            this.m_gzip.addActionListener(this.listener);
            this.m_gzip.setMnemonic('Z');
            this.add(this.m_gzip);
            this.m_gzip.setEnabled(false);
        }
        this.setBorder(BorderFactory.createTitledBorder("Enter the data file name"));
        this.checkIfFileExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfFileExists() {
        boolean enabled;
        String text = this.m_fileName.getText();
        boolean bl = enabled = text.length() > 0;
        if (enabled) {
            File file = new File(text);
            boolean bl2 = enabled = file.exists() && !file.isDirectory() && file.canRead();
            if (this.m_gzip != null) {
                try (FileInputStream in = new FileInputStream(file);){
                    GZIPInputStream gin = new GZIPInputStream(in);
                    ((InputStream)gin).close();
                    this.m_gzip.setSelected(true);
                }
                catch (IOException x) {
                    this.m_gzip.setSelected(false);
                }
            }
        }
        if (enabled != this.wasEnabled) {
            this.wasEnabled = enabled;
            this.fireStateChanged(this.event);
        }
        if (this.m_view != null) {
            this.m_view.setEnabled(enabled);
        }
        if (this.m_gzip != null) {
            this.m_gzip.setEnabled(enabled);
        }
    }

    private void fireStateChanged(ChangeEvent e) {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].stateChanged(e);
        }
    }

    public boolean isFileSelected() {
        return this.wasEnabled;
    }

    public void addChangeListener(ChangeListener cl) {
        this.listenerList.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listenerList.remove(ChangeListener.class, cl);
    }

    public void addActionListener(ActionListener al) {
        this.m_fileName.addActionListener(al);
    }

    public void removeActionListener(ActionListener al) {
        this.m_fileName.removeActionListener(al);
    }

    public String getText() {
        return this.wasEnabled ? this.m_fileName.getText() : "";
    }

    public File getFile() {
        return this.wasEnabled ? new File(this.m_fileName.getText()) : null;
    }

    public void saveState() {
        this.m_fileName.saveState();
    }

    public boolean getGZIPed() {
        return this.m_gzip == null ? false : this.m_gzip.isSelected();
    }

    private class MyListener
    implements ActionListener,
    ChangeListener {
        private MyListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == OpenLocalFilePanel.this.m_browse) {
                JFileChooser dlg = new JFileChooser(OpenLocalFilePanel.this.m_prop.getProperty(OpenLocalFilePanel.this.m_lastLocalDirectory_Key, "{user.home}"));
                dlg.setDialogTitle("Select a file");
                dlg.setApproveButtonText("Select");
                if (OpenLocalFilePanel.this.m_filter != null) {
                    dlg.setFileFilter(OpenLocalFilePanel.this.m_filter);
                }
                if (dlg.showOpenDialog(OpenLocalFilePanel.this) == 0) {
                    File file = dlg.getSelectedFile();
                    OpenLocalFilePanel.this.m_fileName.setText(file.getAbsolutePath());
                    OpenLocalFilePanel.this.m_prop.setProperty(OpenLocalFilePanel.this.m_lastLocalDirectory_Key, file.getParent());
                }
            } else if (source == OpenLocalFilePanel.this.m_view) {
                try {
                    FilePreview.create(OpenLocalFilePanel.this, new File(OpenLocalFilePanel.this.m_fileName.getText()), OpenLocalFilePanel.this.m_gzip == null ? false : OpenLocalFilePanel.this.m_gzip.isSelected());
                }
                catch (Exception x) {
                    Application.error((Component)OpenLocalFilePanel.this, (String)"Error opening file", (Throwable)x);
                }
            }
        }

        @Override
        public final void stateChanged(ChangeEvent e) {
            OpenLocalFilePanel.this.checkIfFileExists();
        }
    }

    private static class PreviewReader
    extends LineNumberReader {
        private final int maxLines = 100;

        PreviewReader(Reader r) {
            super(r);
        }

        @Override
        public int read() throws IOException {
            return this.getLineNumber() > 100 ? -1 : super.read();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.getLineNumber() > 100 ? -1 : super.read(cbuf, off, len);
        }

        @Override
        public String readLine() throws IOException {
            return this.getLineNumber() > 100 ? null : super.readLine();
        }
    }

    private static class FilePreview
    extends JDialog {
        static FilePreview create(Component parent, File f, boolean gzip) throws IOException, FileNotFoundException {
            Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, parent);
            FilePreview result = w instanceof Dialog ? new FilePreview((Dialog)w) : (w instanceof Frame ? new FilePreview((Frame)w) : new FilePreview());
            result.init(f, gzip);
            result.pack();
            result.setLocationRelativeTo(w);
            result.setVisible(true);
            return result;
        }

        private FilePreview() {
        }

        private FilePreview(Frame frame) {
            super(frame);
        }

        private FilePreview(Dialog dlg) {
            super(dlg);
        }

        private void init(File f, boolean gzip) throws IOException, FileNotFoundException {
            this.setTitle("File Preview");
            JTextArea text = new JTextArea();
            if (!gzip) {
                text.read(new PreviewReader(new FileReader(f)), f);
            } else {
                text.read(new PreviewReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(f)))), f);
            }
            text.setEditable(false);
            JScrollPane pane = new JScrollPane(text);
            pane.setPreferredSize(new Dimension(400, 400));
            this.setContentPane(pane);
        }
    }
}

